/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EquivalenceClassProperty {
    private final Map<RowExpression, RowExpression> equivalenceClassHeads = new HashMap<RowExpression, RowExpression>();
    private final Map<RowExpression, List<RowExpression>> equivalenceClasses = new HashMap<RowExpression, List<RowExpression>>();
    private final FunctionResolution functionResolution;
    private boolean updated;

    public EquivalenceClassProperty(FunctionResolution functionResolution) {
        this.functionResolution = functionResolution;
    }

    public boolean isMoreGeneralThan(EquivalenceClassProperty otherEquivalenceClassProperty) {
        Objects.requireNonNull(otherEquivalenceClassProperty, "otherEquivalenceClassProperty is null");
        if (this.equivalenceClasses.isEmpty() && otherEquivalenceClassProperty.equivalenceClasses.isEmpty()) {
            return true;
        }
        if (this.equivalenceClasses.isEmpty() || otherEquivalenceClassProperty.equivalenceClasses.isEmpty()) {
            return false;
        }
        ImmutableList eqClassSets = (ImmutableList)this.equivalenceClasses.entrySet().stream().map(e1 -> new ImmutableSet.Builder().add(e1.getKey()).addAll((Iterable)e1.getValue()).build()).collect(ImmutableList.toImmutableList());
        return otherEquivalenceClassProperty.equivalenceClasses.entrySet().stream().allMatch(e -> {
            HashSet otherEqClass = new HashSet();
            otherEqClass.add(e.getKey());
            otherEqClass.addAll((Collection)e.getValue());
            return eqClassSets.stream().anyMatch(eqClassSet -> eqClassSet.containsAll((Collection)otherEqClass));
        });
    }

    public RowExpression getEquivalenceClassHead(RowExpression expression) {
        Objects.requireNonNull(expression, "expression is null");
        Preconditions.checkArgument((expression instanceof VariableReferenceExpression || expression instanceof ConstantExpression ? 1 : 0) != 0, (Object)("Row expression is of type " + expression.getClass().getSimpleName() + ", must be a VariableReferenceExpression or a ConstantExpression."));
        return this.equivalenceClassHeads.getOrDefault(expression, expression);
    }

    public List<RowExpression> getEquivalenceClasses(RowExpression head) {
        Objects.requireNonNull(head, "head is null");
        Preconditions.checkArgument((head instanceof VariableReferenceExpression || head instanceof ConstantExpression ? 1 : 0) != 0, (Object)("Row expression is of type " + head.getClass().getSimpleName() + ", must be a VariableReferenceExpression or a ConstantExpression."));
        return this.equivalenceClasses.getOrDefault(head, new ArrayList());
    }

    public void update(EquivalenceClassProperty equivalenceClassProperty) {
        Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
        equivalenceClassProperty.equivalenceClasses.forEach((head, members) -> members.forEach(member -> this.updateInternal((RowExpression)head, (RowExpression)member)));
    }

    public boolean update(RowExpression predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        this.updated = false;
        LogicalRowExpressions.extractConjuncts((RowExpression)predicate).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(this::isVariableEqualVariableOrConstant).forEach(e -> this.updateInternal((RowExpression)e.getArguments().get(0), (RowExpression)e.getArguments().get(1)));
        return this.updated;
    }

    private boolean isVariableEqualVariableOrConstant(RowExpression expression) {
        if (expression instanceof CallExpression && this.functionResolution.isEqualFunction(((CallExpression)expression).getFunctionHandle()) && ((CallExpression)expression).getArguments().size() == 2) {
            RowExpression e1 = (RowExpression)((CallExpression)expression).getArguments().get(0);
            RowExpression e2 = (RowExpression)((CallExpression)expression).getArguments().get(1);
            return e1 instanceof VariableReferenceExpression && (e2 instanceof VariableReferenceExpression || e2 instanceof ConstantExpression) || e2 instanceof VariableReferenceExpression && e1 instanceof ConstantExpression;
        }
        return false;
    }

    public void update(RowExpression firstExpression, RowExpression secondExpression) {
        this.updateInternal(firstExpression, secondExpression);
    }

    private void updateInternal(RowExpression firstExpression, RowExpression secondExpression) {
        RowExpression head2;
        RowExpression head1 = this.getEquivalenceClassHead(firstExpression);
        if (head1 == (head2 = this.getEquivalenceClassHead(secondExpression))) {
            return;
        }
        this.updated = true;
        List<RowExpression> head1Class = this.getEquivalenceClasses(head1);
        List<RowExpression> head2Class = this.getEquivalenceClasses(head2);
        RowExpression newHead = this.pickNewHead(head1, head2);
        if (newHead == head1) {
            head1Class.addAll(head2Class);
            head1Class.add(head2);
            this.combineClasses(head1, head1Class, head2, head2Class);
        } else {
            head2Class.addAll(head1Class);
            head2Class.add(head1);
            this.combineClasses(head2, head2Class, head1, head1Class);
        }
    }

    private RowExpression pickNewHead(RowExpression head1, RowExpression head2) {
        if (head2 instanceof ConstantExpression) {
            return head2;
        }
        return head1;
    }

    private void combineClasses(RowExpression head, List<RowExpression> headClass, RowExpression headOfOtherEqClass, List<RowExpression> otherEqClass) {
        this.equivalenceClassHeads.put(headOfOtherEqClass, head);
        for (RowExpression expression : otherEqClass) {
            this.equivalenceClassHeads.put(expression, head);
        }
        this.equivalenceClasses.putIfAbsent(head, headClass);
        this.equivalenceClasses.remove(headOfOtherEqClass);
    }

    public EquivalenceClassProperty project(Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableMappings) {
        EquivalenceClassProperty projectedEquivalenceClassProperty = new EquivalenceClassProperty(this.functionResolution);
        for (Map.Entry<RowExpression, List<RowExpression>> entry : this.equivalenceClasses.entrySet()) {
            RowExpression currentHead;
            ArrayList<RowExpression> projectedMembers = new ArrayList<RowExpression>();
            for (RowExpression member : entry.getValue()) {
                RowExpression projectedMember;
                if (!inverseVariableMappings.containsKey(member) || projectedMembers.contains(projectedMember = (RowExpression)inverseVariableMappings.get(member))) continue;
                projectedMembers.add(projectedMember);
            }
            if (projectedMembers.isEmpty()) continue;
            RowExpression projectedHead = currentHead = entry.getKey();
            if (currentHead instanceof VariableReferenceExpression) {
                if (inverseVariableMappings.containsKey(currentHead)) {
                    projectedHead = (RowExpression)inverseVariableMappings.get(currentHead);
                    projectedMembers.remove(projectedHead);
                } else {
                    projectedHead = (RowExpression)projectedMembers.get(0);
                    projectedMembers.remove(0);
                }
            }
            RowExpression finalProjectedHead = projectedHead;
            projectedMembers.forEach(m -> projectedEquivalenceClassProperty.update(finalProjectedHead, (RowExpression)m));
        }
        return projectedEquivalenceClassProperty;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("EquivalenceClassHeads", (Object)String.join((CharSequence)",", (Iterable)this.equivalenceClassHeads.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(ImmutableList.toImmutableList()))).add("EquivalenceClasses", (Object)String.join((CharSequence)",", (Iterable)this.equivalenceClasses.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(ImmutableList.toImmutableList()))).toString();
    }
}

