/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public class SqlPlannerContext {
    private int leafNodesInLogicalPlan;

    public SqlPlannerContext(int leafNodesInLogicalPlan) {
        this.leafNodesInLogicalPlan = leafNodesInLogicalPlan;
    }

    public void incrementLeafNodes(Session session) {
        ++this.leafNodesInLogicalPlan;
        if (SystemSessionProperties.isLeafNodeLimitEnabled(session) && this.leafNodesInLogicalPlan > SystemSessionProperties.getMaxLeafNodesInPlan(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_PLAN_NODE_LIMIT, String.format("Number of leaf nodes in logical plan exceeds threshold %s set in max_leaf_nodes_in_plan", SystemSessionProperties.getMaxLeafNodesInPlan(session)));
        }
    }
}

