/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class GroupingOperationRewriter {
    private GroupingOperationRewriter() {
    }

    public static Expression rewriteGroupingOperation(GroupingOperation expression, List<Set<Integer>> groupingSets, Multimap<NodeRef<Expression>, FieldId> columnReferenceFields, Optional<VariableReferenceExpression> groupIdVariable) {
        Objects.requireNonNull(groupIdVariable, "groupIdVariable is null");
        if (groupingSets.size() == 1) {
            return new LongLiteral("0");
        }
        Preconditions.checkState((boolean)groupIdVariable.isPresent(), (Object)"groupId symbol is missing");
        RelationId relationId = ExpressionTreeUtils.checkAndGetColumnReferenceField((Expression)expression.getGroupingColumns().get(0), columnReferenceFields).getRelationId();
        List columns = (List)expression.getGroupingColumns().stream().map(NodeRef::of).peek(groupingColumn -> Preconditions.checkState((boolean)columnReferenceFields.containsKey(groupingColumn), (Object)"the grouping column is not in the columnReferencesField map")).map(arg_0 -> columnReferenceFields.get(arg_0)).flatMap(Collection::stream).map(fieldId -> GroupingOperationRewriter.translateFieldToInteger(fieldId, relationId)).collect(ImmutableList.toImmutableList());
        List groupingResults = (List)groupingSets.stream().map(groupingSet -> String.valueOf(GroupingOperationRewriter.calculateGrouping(groupingSet, columns))).map(LongLiteral::new).collect(ImmutableList.toImmutableList());
        return new SubscriptExpression((Expression)new ArrayConstructor(groupingResults), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)ExpressionTreeUtils.createSymbolReference(groupIdVariable.get()), (Expression)new GenericLiteral("BIGINT", "1")));
    }

    private static int translateFieldToInteger(FieldId fieldId, RelationId requiredOriginRelationId) {
        Preconditions.checkState((boolean)fieldId.getRelationId().equals((Object)requiredOriginRelationId), (Object)"grouping arguments must all come from the same relation");
        return fieldId.getFieldIndex();
    }

    static long calculateGrouping(Set<Integer> groupingSet, List<Integer> columns) {
        long grouping = (1L << columns.size()) - 1L;
        for (int index = 0; index < columns.size(); ++index) {
            int column = columns.get(index);
            if (!groupingSet.contains(column)) continue;
            grouping &= 1L << columns.size() - 1 - index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return grouping;
    }
}

