/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class EffectivePredicateExtractor {
    private final RowExpressionDomainTranslator domainTranslator;
    private final FunctionAndTypeManager functionAndTypeManager;

    public EffectivePredicateExtractor(RowExpressionDomainTranslator domainTranslator, FunctionAndTypeManager functionAndTypeManager) {
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        this.functionAndTypeManager = functionAndTypeManager;
    }

    public RowExpression extract(PlanNode node) {
        return (RowExpression)node.accept((PlanVisitor)new Visitor(this.domainTranslator, this.functionAndTypeManager), null);
    }

    private static class Visitor
    extends InternalPlanVisitor<RowExpression, Void> {
        private final RowExpressionDomainTranslator domainTranslator;
        private final LogicalRowExpressions logicalRowExpressions;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final FunctionAndTypeManager functionManger;

        public Visitor(RowExpressionDomainTranslator domainTranslator, FunctionAndTypeManager functionAndTypeManager) {
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.functionManger = Objects.requireNonNull(functionAndTypeManager);
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
            this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)this.determinismEvaluator, (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager), (FunctionMetadataManager)functionAndTypeManager);
        }

        public RowExpression visitPlan(PlanNode node, Void context) {
            return LogicalRowExpressions.TRUE_CONSTANT;
        }

        public RowExpression visitAggregation(AggregationNode node, Void context) {
            if (node.getGroupingKeys().isEmpty()) {
                return LogicalRowExpressions.TRUE_CONSTANT;
            }
            RowExpression underlyingPredicate = (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
            return this.pullExpressionThroughVariables(underlyingPredicate, node.getGroupingKeys());
        }

        public RowExpression visitFilter(FilterNode node, Void context) {
            RowExpression underlyingPredicate = (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
            RowExpression predicate = node.getPredicate();
            predicate = this.logicalRowExpressions.filterDeterministicConjuncts(predicate);
            return this.logicalRowExpressions.combineConjuncts(new RowExpression[]{predicate, underlyingPredicate});
        }

        @Override
        public RowExpression visitExchange(ExchangeNode node, Void context) {
            return this.deriveCommonPredicates(node, source -> {
                HashMap<VariableReferenceExpression, VariableReferenceExpression> mappings = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                for (int i = 0; i < node.getInputs().get((int)source).size(); ++i) {
                    mappings.put(node.getOutputVariables().get(i), node.getInputs().get((int)source).get(i));
                }
                return mappings.entrySet();
            });
        }

        @Override
        public RowExpression visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            if (node.getSource() instanceof ProjectNode) {
                return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
            }
            return LogicalRowExpressions.TRUE_CONSTANT;
        }

        public RowExpression visitProject(ProjectNode node, Void context) {
            RowExpression underlyingPredicate = (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
            List projectionEqualities = (List)node.getAssignments().getMap().entrySet().stream().filter(this::notIdentityAssignment).filter(this::canCompareEquity).map(this::toEquality).collect(ImmutableList.toImmutableList());
            return this.pullExpressionThroughVariables(this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().addAll((Iterable)projectionEqualities).add((Object)underlyingPredicate).build()), node.getOutputVariables());
        }

        public RowExpression visitTopN(TopNNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public RowExpression visitLimit(LimitNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public RowExpression visitAssignUniqueId(AssignUniqueId node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public RowExpression visitDistinctLimit(DistinctLimitNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public RowExpression visitTableScan(TableScanNode node, Void context) {
            ImmutableBiMap assignments = ImmutableBiMap.copyOf((Map)node.getAssignments()).inverse();
            return this.domainTranslator.toPredicate(node.getCurrentConstraint().simplify().transform(arg_0 -> Visitor.lambda$visitTableScan$1((Map)assignments, arg_0)));
        }

        @Override
        public RowExpression visitSort(SortNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public RowExpression visitWindow(WindowNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public RowExpression visitUnion(UnionNode node, Void context) {
            return this.deriveCommonPredicates((PlanNode)node, source -> SetOperationNodeUtils.outputMap(node, source).entries());
        }

        @Override
        public RowExpression visitJoin(JoinNode node, Void context) {
            RowExpression leftPredicate = (RowExpression)node.getLeft().accept((PlanVisitor)this, (Object)context);
            RowExpression rightPredicate = (RowExpression)node.getRight().accept((PlanVisitor)this, (Object)context);
            List joinConjuncts = (List)node.getCriteria().stream().map(this::toRowExpression).collect(ImmutableList.toImmutableList());
            switch (node.getType()) {
                case INNER: {
                    return this.pullExpressionThroughVariables(this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().add((Object)leftPredicate).add((Object)rightPredicate).add((Object)this.logicalRowExpressions.combineConjuncts((Collection)joinConjuncts)).add((Object)node.getFilter().orElse((RowExpression)LogicalRowExpressions.TRUE_CONSTANT)).build()), node.getOutputVariables());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputVariables()::contains;
                    Predicate[] predicateArray2 = new Predicate[1];
                    predicateArray2[0] = node.getRight().getOutputVariables()::contains;
                    return this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(LogicalRowExpressions.extractConjuncts((RowExpression)rightPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray2)).build());
                }
                case RIGHT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputVariables()::contains;
                    Predicate[] predicateArray3 = new Predicate[1];
                    predicateArray3[0] = node.getLeft().getOutputVariables()::contains;
                    return this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(rightPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(LogicalRowExpressions.extractConjuncts((RowExpression)leftPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray3)).build());
                }
                case FULL: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputVariables()::contains;
                    Predicate[] predicateArray4 = new Predicate[1];
                    predicateArray4[0] = node.getRight().getOutputVariables()::contains;
                    Predicate[] predicateArray5 = new Predicate[2];
                    predicateArray5[0] = node.getLeft().getOutputVariables()::contains;
                    predicateArray5[1] = node.getRight().getOutputVariables()::contains;
                    return this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().addAll(this.pullNullableConjunctsThroughOuterJoin(LogicalRowExpressions.extractConjuncts((RowExpression)leftPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(LogicalRowExpressions.extractConjuncts((RowExpression)rightPredicate), node.getOutputVariables(), predicateArray4)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray5)).build());
                }
            }
            throw new UnsupportedOperationException("Unknown join type: " + (Object)((Object)node.getType()));
        }

        private Iterable<RowExpression> pullNullableConjunctsThroughOuterJoin(List<RowExpression> conjuncts, Collection<VariableReferenceExpression> outputVariables, Predicate<VariableReferenceExpression> ... nullVariableScopes) {
            return (Iterable)conjuncts.stream().map(expression -> this.pullExpressionThroughVariables((RowExpression)expression, outputVariables)).map(expression -> VariablesExtractor.extractAll(expression).isEmpty() ? LogicalRowExpressions.TRUE_CONSTANT : expression).map(this.expressionOrNullVariables(nullVariableScopes)).collect(ImmutableList.toImmutableList());
        }

        public Function<RowExpression, RowExpression> expressionOrNullVariables(Predicate<VariableReferenceExpression> ... nullVariableScopes) {
            return expression -> {
                ImmutableList.Builder resultDisjunct = ImmutableList.builder();
                resultDisjunct.add(expression);
                for (Predicate nullVariableScope : nullVariableScopes) {
                    List variables = (List)VariablesExtractor.extractUnique(expression).stream().filter(nullVariableScope).collect(ImmutableList.toImmutableList());
                    if (Iterables.isEmpty((Iterable)variables)) continue;
                    ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                    for (VariableReferenceExpression variable : variables) {
                        nullConjuncts.add((Object)Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{variable}));
                    }
                    resultDisjunct.add((Object)LogicalRowExpressions.and((Collection)nullConjuncts.build()));
                }
                return LogicalRowExpressions.or((Collection)resultDisjunct.build());
            };
        }

        @Override
        public RowExpression visitSemiJoin(SemiJoinNode node, Void context) {
            return (RowExpression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public RowExpression visitSpatialJoin(SpatialJoinNode node, Void context) {
            RowExpression leftPredicate = (RowExpression)node.getLeft().accept((PlanVisitor)this, (Object)context);
            RowExpression rightPredicate = (RowExpression)node.getRight().accept((PlanVisitor)this, (Object)context);
            switch (node.getType()) {
                case INNER: {
                    return this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).add((Object)this.pullExpressionThroughVariables(rightPredicate, node.getOutputVariables())).build());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputVariables()::contains;
                    return this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(LogicalRowExpressions.extractConjuncts((RowExpression)rightPredicate), node.getOutputVariables(), predicateArray)).build());
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
        }

        private RowExpression toRowExpression(JoinNode.EquiJoinClause equiJoinClause) {
            return Visitor.buildEqualsExpression(this.functionManger, (RowExpression)equiJoinClause.getLeft(), (RowExpression)equiJoinClause.getRight());
        }

        private RowExpression deriveCommonPredicates(PlanNode node, Function<Integer, Collection<Map.Entry<VariableReferenceExpression, VariableReferenceExpression>>> mapping) {
            ArrayList<ImmutableSet> sourceOutputConjuncts = new ArrayList<ImmutableSet>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                RowExpression underlyingPredicate = (RowExpression)((PlanNode)node.getSources().get(i)).accept((PlanVisitor)this, null);
                List equalities = (List)mapping.apply(i).stream().filter(this::notIdentityAssignment).filter(this::canCompareEquity).map(this::toEquality).collect(ImmutableList.toImmutableList());
                sourceOutputConjuncts.add(ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)this.pullExpressionThroughVariables(this.logicalRowExpressions.combineConjuncts((Collection)ImmutableList.builder().addAll((Iterable)equalities).add((Object)underlyingPredicate).build()), node.getOutputVariables()))));
            }
            Iterator iterator = sourceOutputConjuncts.iterator();
            Set potentialOutputConjuncts = (Set)iterator.next();
            while (iterator.hasNext()) {
                potentialOutputConjuncts = Sets.intersection((Set)potentialOutputConjuncts, (Set)((Set)iterator.next()));
            }
            return this.logicalRowExpressions.combineConjuncts((Collection)potentialOutputConjuncts);
        }

        private boolean notIdentityAssignment(Map.Entry<VariableReferenceExpression, ? extends RowExpression> entry) {
            return !entry.getKey().equals((Object)entry.getValue());
        }

        private boolean canCompareEquity(Map.Entry<VariableReferenceExpression, ? extends RowExpression> entry) {
            try {
                this.functionManger.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{entry.getKey().getType(), entry.getValue().getType()}));
                return true;
            }
            catch (OperatorNotFoundException e) {
                return false;
            }
        }

        private RowExpression toEquality(Map.Entry<VariableReferenceExpression, ? extends RowExpression> entry) {
            return Visitor.buildEqualsExpression(this.functionManger, (RowExpression)entry.getKey(), entry.getValue());
        }

        private static CallExpression buildEqualsExpression(FunctionAndTypeManager functionAndTypeManager, RowExpression left, RowExpression right) {
            return Expressions.call((Optional<SourceLocation>)left.getSourceLocation(), OperatorType.EQUAL.getFunctionName().getObjectName(), functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)BooleanType.BOOLEAN, left, right);
        }

        private RowExpression pullExpressionThroughVariables(RowExpression expression, Collection<VariableReferenceExpression> variables) {
            EqualityInference equalityInference = new EqualityInference.Builder(this.functionManger).addEqualityInference(expression).build();
            ImmutableList.Builder effectiveConjuncts = ImmutableList.builder();
            for (RowExpression conjunct : new EqualityInference.Builder(this.functionManger).nonInferableConjuncts(expression)) {
                RowExpression rewritten;
                if (!this.determinismEvaluator.isDeterministic(conjunct) || (rewritten = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(variables))) == null) continue;
                effectiveConjuncts.add((Object)rewritten);
            }
            effectiveConjuncts.addAll(equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(variables)).getScopeEqualities());
            return this.logicalRowExpressions.combineConjuncts((Collection)effectiveConjuncts.build());
        }

        private static /* synthetic */ VariableReferenceExpression lambda$visitTableScan$1(Map assignments, ColumnHandle column) {
            return assignments.containsKey(column) ? (VariableReferenceExpression)assignments.get(column) : null;
        }
    }
}

