/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.CanonicalRowExpressionRewriter;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.CanonicalJoinNode;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.StatsEquivalentPlanNodeWithLimit;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class CanonicalPlanGenerator
extends InternalPlanVisitor<Optional<PlanNode>, Context> {
    private final PlanNodeIdAllocator planNodeidAllocator = new PlanNodeIdAllocator();
    private final PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
    private final PlanCanonicalizationStrategy strategy;
    private final ObjectMapper objectMapper;

    public CanonicalPlanGenerator(PlanCanonicalizationStrategy strategy, ObjectMapper objectMapper) {
        this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    public static Optional<CanonicalPlanFragment> generateCanonicalPlanFragment(PlanNode root, PartitioningScheme partitioningScheme, ObjectMapper objectMapper) {
        Context context = new Context();
        Optional canonicalPlan = (Optional)root.accept((PlanVisitor)new CanonicalPlanGenerator(PlanCanonicalizationStrategy.DEFAULT, objectMapper), (Object)context);
        if (!context.getExpressions().keySet().containsAll(partitioningScheme.getOutputLayout())) {
            return Optional.empty();
        }
        return canonicalPlan.map(planNode -> new CanonicalPlanFragment(new CanonicalPlan((PlanNode)planNode, PlanCanonicalizationStrategy.DEFAULT), CanonicalPartitioningScheme.getCanonicalPartitioningScheme(partitioningScheme, context.getExpressions())));
    }

    public static Optional<CanonicalPlan> generateCanonicalPlan(PlanNode root, PlanCanonicalizationStrategy strategy, ObjectMapper objectMapper) {
        Optional canonicalPlanNode = (Optional)root.accept((PlanVisitor)new CanonicalPlanGenerator(strategy, objectMapper), (Object)new Context());
        return canonicalPlanNode.map(planNode -> new CanonicalPlan((PlanNode)planNode, strategy));
    }

    public Optional<PlanNode> visitPlan(PlanNode node, Context context) {
        return Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitStatsEquivalentPlanNodeWithLimit(StatsEquivalentPlanNodeWithLimit node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional limit = (Optional)node.getLimit().accept((PlanVisitor)this, (Object)context);
        if (!limit.isPresent()) {
            return Optional.empty();
        }
        Optional plan = (Optional)node.getPlan().accept((PlanVisitor)this, (Object)context);
        if (!plan.isPresent()) {
            return Optional.empty();
        }
        StatsEquivalentPlanNodeWithLimit result = new StatsEquivalentPlanNodeWithLimit(this.planNodeidAllocator.getNextId(), (PlanNode)plan.get(), (LimitNode)limit.get());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitTableWriter(TableWriterNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List columns = (List)node.getColumns().stream().map(variable -> this.rename((VariableReferenceExpression)variable, context)).sorted().collect(ImmutableList.toImmutableList());
        List columnNames = (List)node.getColumnNames().stream().sorted().collect(ImmutableList.toImmutableList());
        TableWriterNode result = new TableWriterNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getTarget().map(target -> CanonicalWriterTarget.from(target)), node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), columns, columnNames, (Set<VariableReferenceExpression>)ImmutableSet.of(), Optional.empty(), Optional.empty(), Optional.empty());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitTableFinish(TableFinishNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        TableFinishNode result = new TableFinishNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getTarget().map(target -> CanonicalWriterTarget.from(target)), node.getRowCountVariable(), Optional.empty(), Optional.empty());
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    public Optional<PlanNode> visitLimit(LimitNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        LimitNode result = new LimitNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), node.getCount(), node.getStep());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitJoin(JoinNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        if (node.getType().equals((Object)JoinNode.Type.RIGHT)) {
            return this.visitJoin(node.flipChildren(), context);
        }
        ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
        ImmutableList.Builder allFilters = ImmutableList.builder();
        ImmutableList.Builder criterias = ImmutableList.builder();
        Stack<JoinNode> stack = new Stack<JoinNode>();
        stack.push(node);
        while (!stack.empty()) {
            JoinNode top = (JoinNode)((Object)stack.pop());
            top.getCriteria().forEach(arg_0 -> ((ImmutableList.Builder)criterias).add(arg_0));
            if (top.getFilter().isPresent()) {
                List filters = LogicalRowExpressions.extractConjuncts((RowExpression)top.getFilter().get());
                filters.forEach(filter -> {
                    Optional<JoinNode.EquiJoinClause> criteria = CanonicalPlanGenerator.toEquiJoinClause(filter);
                    criteria.ifPresent(arg_0 -> ((ImmutableList.Builder)criterias).add(arg_0));
                    allFilters.add(filter);
                });
            }
            top.getSources().forEach(source -> {
                if (source instanceof JoinNode && ((JoinNode)((Object)source)).getType().equals((Object)node.getType()) && this.shouldMergeJoinNodes(node.getType())) {
                    stack.push((JoinNode)((Object)source));
                } else {
                    sources.add((PlanNode)source);
                }
            });
        }
        if (this.shouldMergeJoinNodes(node.getType()) || node.getType().equals((Object)JoinNode.Type.FULL) && sources.size() == 2) {
            IdentityHashMap<PlanNode, String> sourceKeys = new IdentityHashMap<PlanNode, String>();
            for (PlanNode source2 : sources) {
                Optional<CanonicalPlan> canonicalSource = CanonicalPlanGenerator.generateCanonicalPlan(source2, this.strategy, this.objectMapper);
                if (!canonicalSource.isPresent()) {
                    return Optional.empty();
                }
                sourceKeys.put(source2, canonicalSource.get().toString(this.objectMapper));
            }
            sources.sort(Comparator.comparing(sourceKeys::get));
        }
        List newSources = (List)sources.stream().map(source -> (PlanNode)((Optional)source.accept((PlanVisitor)this, (Object)context)).get()).collect(ImmutableList.toImmutableList());
        Set newCriterias = criterias.build().stream().map(criteria -> CanonicalPlanGenerator.canonicalize(criteria, context)).sorted(Comparator.comparing(JoinNode.EquiJoinClause::toString)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set newFilters = allFilters.build().stream().map(filter -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), filter)).sorted(Comparator.comparing(RowExpression::toString)).collect(Collectors.toCollection(LinkedHashSet::new));
        List outputVariables = (List)node.getOutputVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).sorted().collect(ImmutableList.toImmutableList());
        CanonicalJoinNode result = new CanonicalJoinNode(this.planNodeidAllocator.getNextId(), newSources, node.getType(), newCriterias, newFilters, outputVariables);
        context.addPlan(node, new CanonicalPlan(result, this.strategy));
        return Optional.of(result);
    }

    public Optional<PlanNode> visitUnion(UnionNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        TreeMultimap sourceToPosition = TreeMultimap.create();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = (PlanNode)node.getSources().get(i);
            Optional<CanonicalPlan> canonicalSource = CanonicalPlanGenerator.generateCanonicalPlan(source, this.strategy, this.objectMapper);
            if (!canonicalSource.isPresent()) {
                return Optional.empty();
            }
            sourceToPosition.put((Object)canonicalSource.get().toString(this.objectMapper), (Object)i);
        }
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        ImmutableMap.Builder outputsToInputs = ImmutableMap.builder();
        sourceToPosition.forEach((ignored, index) -> {
            PlanNode canonicalSource = (PlanNode)((Optional)((PlanNode)node.getSources().get((int)index)).accept((PlanVisitor)this, (Object)context)).get();
            sources.add((Object)canonicalSource);
        });
        node.getVariableMapping().forEach((arg_0, arg_1) -> this.lambda$visitUnion$13((Multimap)sourceToPosition, context, outputVariables, outputsToInputs, arg_0, arg_1));
        UnionNode result = new UnionNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (List)sources.build(), (List)outputVariables.build().stream().sorted().collect(ImmutableList.toImmutableList()), (Map)ImmutableSortedMap.copyOf((Map)outputsToInputs.build()));
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)result, this.strategy));
        return Optional.of(result);
    }

    @Override
    public Optional<PlanNode> visitOutput(OutputNode node, Context context) {
        if (this.strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return Optional.empty();
        }
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List rowExpressionReferences = (List)node.getOutputVariables().stream().map(variable -> new RowExpressionReference((RowExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable, this.strategy == PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS), (VariableReferenceExpression)variable)).sorted(Comparator.comparing(rowExpressionReference -> rowExpressionReference.getRowExpression().toString())).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (RowExpressionReference rowExpressionReference2 : rowExpressionReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(rowExpressionReference2.getRowExpression());
            context.mapExpression(rowExpressionReference2.getVariableReferenceExpression(), reference);
            assignments.put((Object)reference, (Object)rowExpressionReference2.getRowExpression());
        }
        ProjectNode canonicalPlan = new ProjectNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new Assignments((Map)assignments.build()), ProjectNode.Locality.LOCAL);
        context.addPlan(node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitAggregation(AggregationNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List aggregationReferences = (List)node.getAggregations().entrySet().stream().map(entry -> new AggregationReference(this.getCanonicalAggregation((AggregationNode.Aggregation)entry.getValue(), context.getExpressions()), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(aggregationReference -> aggregationReference.getAggregation().getCall().toString())).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (AggregationReference aggregationReference2 : aggregationReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)aggregationReference2.getAggregation().getCall());
            context.mapExpression(aggregationReference2.getVariableReferenceExpression(), reference);
            aggregations.put((Object)reference, (Object)aggregationReference2.getAggregation());
        }
        AggregationNode canonicalPlan = new AggregationNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (Map)aggregations.build(), CanonicalPlanGenerator.getCanonicalGroupingSetDescriptor(node.getGroupingSets(), context.getExpressions()), (List)node.getPreGroupedVariables().stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()), node.getStep(), node.getHashVariable().map(ignored -> this.variableAllocator.newHashVariable()), node.getGroupIdVariable().map(variable -> context.getExpressions().get(variable)));
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    private AggregationNode.Aggregation getCanonicalAggregation(AggregationNode.Aggregation aggregation, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.Aggregation(CanonicalPlanGenerator.inlineAndCanonicalize(context, aggregation.getCall()), aggregation.getFilter().map(filter -> CanonicalPlanGenerator.inlineAndCanonicalize(context, filter)), aggregation.getOrderBy().map(orderBy -> CanonicalPlanGenerator.getCanonicalOrderingScheme(orderBy, context)), aggregation.isDistinct(), aggregation.getMask().map(context::get));
    }

    private static OrderingScheme getCanonicalOrderingScheme(OrderingScheme orderingScheme, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new OrderingScheme((List)orderingScheme.getOrderBy().stream().map(orderBy -> new Ordering((VariableReferenceExpression)context.get(orderBy.getVariable()), orderBy.getSortOrder())).collect(ImmutableList.toImmutableList()));
    }

    private static AggregationNode.GroupingSetDescriptor getCanonicalGroupingSetDescriptor(AggregationNode.GroupingSetDescriptor groupingSetDescriptor, Map<VariableReferenceExpression, VariableReferenceExpression> context) {
        return new AggregationNode.GroupingSetDescriptor((List)groupingSetDescriptor.getGroupingKeys().stream().map(context::get).collect(ImmutableList.toImmutableList()), groupingSetDescriptor.getGroupingSetCount(), groupingSetDescriptor.getGlobalGroupingSets());
    }

    @Override
    public Optional<PlanNode> visitGroupId(GroupIdNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder groupingColumns = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
            VariableReferenceExpression variableReferenceExpression = context.getExpressions().get(entry.getValue());
            VariableReferenceExpression reference = this.variableAllocator.newVariable((RowExpression)variableReferenceExpression, "gid");
            context.mapExpression(entry.getKey(), reference);
            groupingColumns.put((Object)reference, (Object)variableReferenceExpression);
        }
        ImmutableList.Builder groupingSets = ImmutableList.builder();
        for (List<VariableReferenceExpression> list : node.getGroupingSets()) {
            groupingSets.add(list.stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()));
        }
        VariableReferenceExpression variableReferenceExpression = this.variableAllocator.newVariable("groupid", (Type)IntegerType.INTEGER);
        context.mapExpression(node.getGroupIdVariable(), variableReferenceExpression);
        GroupIdNode groupIdNode = new GroupIdNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List<List<VariableReferenceExpression>>)groupingSets.build(), (Map<VariableReferenceExpression, VariableReferenceExpression>)groupingColumns.build(), (List)node.getAggregationArguments().stream().map(variable -> context.getExpressions().get(variable)).collect(ImmutableList.toImmutableList()), variableReferenceExpression);
        context.addPlan(node, new CanonicalPlan(groupIdNode, this.strategy));
        return Optional.of(groupIdNode);
    }

    @Override
    public Optional<PlanNode> visitUnnest(UnnestNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        ImmutableMap.Builder newUnnestVariables = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariable : node.getUnnestVariables().entrySet()) {
            VariableReferenceExpression input = (VariableReferenceExpression)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)unnestVariable.getKey());
            ImmutableList.Builder newVariables = ImmutableList.builder();
            for (VariableReferenceExpression variable2 : unnestVariable.getValue()) {
                VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_field", variable2.getType());
                context.mapExpression(variable2, newVariable);
                newVariables.add((Object)newVariable);
            }
            newUnnestVariables.put((Object)input, (Object)newVariables.build());
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.getOrdinalityVariable().map(variable -> {
            VariableReferenceExpression newVariable = this.variableAllocator.newVariable(Optional.empty(), "unnest_ordinality", variable.getType());
            context.mapExpression((VariableReferenceExpression)variable, newVariable);
            return newVariable;
        });
        UnnestNode canonicalPlan = new UnnestNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), (List)node.getReplicateVariables().stream().map(variable -> CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable)).collect(ImmutableList.toImmutableList()), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)newUnnestVariables.build(), ordinalityVariable);
        context.addPlan(node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitProject(ProjectNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        List rowExpressionReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new RowExpressionReference(CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)entry.getValue(), this.strategy == PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(rowExpressionReference -> rowExpressionReference.getRowExpression().toString())).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (RowExpressionReference rowExpressionReference2 : rowExpressionReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(rowExpressionReference2.getRowExpression());
            context.mapExpression(rowExpressionReference2.getVariableReferenceExpression(), reference);
            assignments.put((Object)reference, (Object)rowExpressionReference2.getRowExpression());
        }
        ProjectNode canonicalPlan = new ProjectNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), new Assignments((Map)assignments.build()), node.getLocality());
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitFilter(FilterNode node, Context context) {
        Optional source = (Optional)node.getSource().accept((PlanVisitor)this, (Object)context);
        if (!source.isPresent()) {
            return Optional.empty();
        }
        FilterNode canonicalPlan = new FilterNode(Optional.empty(), this.planNodeidAllocator.getNextId(), (PlanNode)source.get(), CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), node.getPredicate()));
        context.addPlan((PlanNode)node, new CanonicalPlan((PlanNode)canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    public Optional<PlanNode> visitTableScan(TableScanNode node, Context context) {
        List columnReferences = (List)node.getAssignments().entrySet().stream().map(entry -> new ColumnReference((ColumnHandle)entry.getValue(), (VariableReferenceExpression)entry.getKey())).sorted(Comparator.comparing(columnReference -> columnReference.getColumnHandle().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (ColumnReference columnReference2 : columnReferences) {
            VariableReferenceExpression reference = this.variableAllocator.newVariable(Optional.empty(), columnReference2.getColumnHandle().toString(), columnReference2.getVariableReferenceExpression().getType());
            context.mapExpression(columnReference2.getVariableReferenceExpression(), reference);
            outputVariables.add((Object)reference);
            assignments.put((Object)reference, (Object)columnReference2.getColumnHandle());
        }
        CanonicalTableScanNode canonicalPlan = new CanonicalTableScanNode(Optional.empty(), this.planNodeidAllocator.getNextId(), CanonicalTableScanNode.CanonicalTableHandle.getCanonicalTableHandle(node.getTable(), this.strategy), (List<VariableReferenceExpression>)outputVariables.build(), (Map<VariableReferenceExpression, ColumnHandle>)assignments.build());
        context.addPlan((PlanNode)node, new CanonicalPlan(canonicalPlan, this.strategy));
        return Optional.of(canonicalPlan);
    }

    private boolean shouldMergeJoinNodes(JoinNode.Type type) {
        return type.equals((Object)JoinNode.Type.INNER);
    }

    private VariableReferenceExpression rename(VariableReferenceExpression variable, Context context) {
        VariableReferenceExpression newVariable = this.variableAllocator.newVariable(CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), variable));
        context.mapExpression(variable, newVariable);
        return newVariable;
    }

    private static JoinNode.EquiJoinClause canonicalize(JoinNode.EquiJoinClause criteria, Context context) {
        VariableReferenceExpression right;
        VariableReferenceExpression left = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), criteria.getLeft());
        return left.compareTo(right = CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), criteria.getRight())) > 0 ? new JoinNode.EquiJoinClause(left, right) : new JoinNode.EquiJoinClause(right, left);
    }

    private static Optional<JoinNode.EquiJoinClause> toEquiJoinClause(RowExpression expression) {
        boolean isValid;
        if (!(expression instanceof CallExpression)) {
            return Optional.empty();
        }
        CallExpression callExpression = (CallExpression)expression;
        boolean bl = isValid = callExpression.getDisplayName().equals(OperatorType.EQUAL.getFunctionName().getObjectName()) && callExpression.getArguments().size() == 2 && callExpression.getArguments().get(0) instanceof VariableReferenceExpression && callExpression.getArguments().get(1) instanceof VariableReferenceExpression;
        if (!isValid) {
            return Optional.empty();
        }
        return Optional.of(new JoinNode.EquiJoinClause((VariableReferenceExpression)callExpression.getArguments().get(0), (VariableReferenceExpression)callExpression.getArguments().get(1)));
    }

    private static <T extends RowExpression> T inlineAndCanonicalize(Map<VariableReferenceExpression, VariableReferenceExpression> context, T expression) {
        return CanonicalPlanGenerator.inlineAndCanonicalize(context, expression, false);
    }

    private static <T extends RowExpression> T inlineAndCanonicalize(Map<VariableReferenceExpression, VariableReferenceExpression> context, T expression, boolean removeConstants) {
        return (T)CanonicalRowExpressionRewriter.canonicalizeRowExpression((RowExpression)RowExpressionVariableInliner.inlineVariables(variable -> context.getOrDefault(variable, (VariableReferenceExpression)variable), expression), (boolean)removeConstants);
    }

    private /* synthetic */ void lambda$visitUnion$13(Multimap sourceToPosition, Context context, ImmutableList.Builder outputVariables, ImmutableMap.Builder outputsToInputs, VariableReferenceExpression outputVariable, List sourceVariables) {
        ImmutableList.Builder newSourceVariablesBuilder = ImmutableList.builder();
        sourceToPosition.forEach((ignored, index) -> newSourceVariablesBuilder.add((Object)CanonicalPlanGenerator.inlineAndCanonicalize(context.getExpressions(), (RowExpression)sourceVariables.get((int)index))));
        ImmutableList newSourceVariables = newSourceVariablesBuilder.build();
        VariableReferenceExpression newVariable = this.variableAllocator.newVariable((VariableReferenceExpression)newSourceVariables.get(0));
        outputVariables.add((Object)newVariable);
        context.mapExpression(outputVariable, newVariable);
        outputsToInputs.put((Object)newVariable, (Object)newSourceVariables);
    }

    public static class Context {
        private final Map<VariableReferenceExpression, VariableReferenceExpression> expressions = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        private final Map<PlanNode, CanonicalPlan> canonicalPlans = new IdentityHashMap<PlanNode, CanonicalPlan>();

        public Map<VariableReferenceExpression, VariableReferenceExpression> getExpressions() {
            return this.expressions;
        }

        public Map<PlanNode, CanonicalPlan> getCanonicalPlans() {
            return this.canonicalPlans;
        }

        public void mapExpression(VariableReferenceExpression from, VariableReferenceExpression to) {
            this.expressions.put(from, to);
        }

        public void addPlan(PlanNode plan, CanonicalPlan canonicalPlan) {
            this.canonicalPlans.put(plan, canonicalPlan);
        }
    }

    private static class ColumnReference {
        private final ColumnHandle columnHandle;
        private final VariableReferenceExpression variableReferenceExpression;

        public ColumnReference(ColumnHandle columnHandle, VariableReferenceExpression variableReferenceExpression) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public ColumnHandle getColumnHandle() {
            return this.columnHandle;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class RowExpressionReference {
        private final RowExpression rowExpression;
        private final VariableReferenceExpression variableReferenceExpression;

        public RowExpressionReference(RowExpression rowExpression, VariableReferenceExpression variableReferenceExpression) {
            this.rowExpression = Objects.requireNonNull(rowExpression, "rowExpression is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public RowExpression getRowExpression() {
            return this.rowExpression;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }

    private static class CanonicalWriterTarget
    extends TableWriterNode.WriterTarget {
        private final ConnectorId connectorId;
        private final String writerTargetType;

        @JsonCreator
        public CanonicalWriterTarget(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="writerTargetType") String writerTargetType) {
            this.connectorId = connectorId;
            this.writerTargetType = writerTargetType;
        }

        @Override
        @JsonProperty
        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        @JsonProperty
        public String getWriterTargetType() {
            return this.writerTargetType;
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return new SchemaTableName("schema", "table");
        }

        @Override
        public String toString() {
            return String.format("WriterTarget{connectorId: %s, type: %s}", this.connectorId, this.writerTargetType);
        }

        private static CanonicalWriterTarget from(TableWriterNode.WriterTarget target) {
            return new CanonicalWriterTarget(target.getConnectorId(), target.getClass().getSimpleName());
        }
    }

    private static class AggregationReference {
        private final AggregationNode.Aggregation aggregation;
        private final VariableReferenceExpression variableReferenceExpression;

        public AggregationReference(AggregationNode.Aggregation aggregation, VariableReferenceExpression variableReferenceExpression) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.variableReferenceExpression = Objects.requireNonNull(variableReferenceExpression, "variableReferenceExpression is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public VariableReferenceExpression getVariableReferenceExpression() {
            return this.variableReferenceExpression;
        }
    }
}

