/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PlanHasher;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import io.airlift.units.DataSize;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CachingPlanHasher
implements PlanHasher {
    private static final DataSize CACHE_SIZE_BYTES = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private final Cache<CacheKey, String> cache = CacheBuilder.newBuilder().maximumWeight(CACHE_SIZE_BYTES.toBytes()).weigher((key, hash) -> hash.length() + 20).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final ObjectMapper objectMapper;

    public CachingPlanHasher(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    @Override
    public Optional<String> hash(PlanNode planNode, PlanCanonicalizationStrategy strategy) {
        CacheKey key = new CacheKey(planNode, strategy);
        String result = (String)this.cache.getIfPresent((Object)key);
        if (result != null) {
            return Optional.of(result);
        }
        CanonicalPlanGenerator.Context context = new CanonicalPlanGenerator.Context();
        key.getNode().accept((PlanVisitor)new CanonicalPlanGenerator(key.getStrategy(), this.objectMapper), (Object)context);
        context.getCanonicalPlans().forEach((plan, canonicalPlan) -> {
            String hashValue = this.hashCanonicalPlan((CanonicalPlan)canonicalPlan, this.objectMapper);
            this.cache.put((Object)new CacheKey((PlanNode)plan, strategy), (Object)hashValue);
        });
        return Optional.ofNullable(this.cache.getIfPresent((Object)key));
    }

    @VisibleForTesting
    public long getCacheSize() {
        return this.cache.size();
    }

    private String hashCanonicalPlan(CanonicalPlan plan, ObjectMapper objectMapper) {
        return Hashing.sha256().hashString((CharSequence)plan.toString(objectMapper), StandardCharsets.UTF_8).toString();
    }

    private static class CacheKey {
        private final PlanNode node;
        private final PlanCanonicalizationStrategy strategy;

        public CacheKey(PlanNode node, PlanCanonicalizationStrategy strategy) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public PlanCanonicalizationStrategy getStrategy() {
            return this.strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.node == cacheKey.node && this.strategy.equals((Object)cacheKey.strategy);
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.node), this.strategy);
        }
    }
}

