/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.MaterializedViewUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.MaterializedViewPlanValidator;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewColumnMappingExtractor
extends MaterializedViewPlanValidator {
    private final Analysis analysis;
    private final Session session;
    private Map<ConnectorMaterializedViewDefinition.TableColumn, Set<ConnectorMaterializedViewDefinition.TableColumn>> mappedBaseColumns;
    private Map<ConnectorMaterializedViewDefinition.TableColumn, Set<ConnectorMaterializedViewDefinition.TableColumn>> directMappedBaseColumns;
    private List<SchemaTableName> baseTablesOnOuterJoinSide;

    public MaterializedViewColumnMappingExtractor(Analysis analysis, Session session) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.mappedBaseColumns = new HashMap<ConnectorMaterializedViewDefinition.TableColumn, Set<ConnectorMaterializedViewDefinition.TableColumn>>();
        this.directMappedBaseColumns = new HashMap<ConnectorMaterializedViewDefinition.TableColumn, Set<ConnectorMaterializedViewDefinition.TableColumn>>();
        this.baseTablesOnOuterJoinSide = new ArrayList<SchemaTableName>();
        Preconditions.checkState((boolean)(analysis.getStatement() instanceof CreateMaterializedView), (Object)"Only support extracting of mapped columns from create materialized view query");
        Query viewQuery = ((CreateMaterializedView)analysis.getStatement()).getQuery();
        this.process((Node)viewQuery, new MaterializedViewPlanValidator.MaterializedViewPlanValidatorContext());
        this.mappedBaseColumns = MaterializedViewUtils.transitiveClosure(this.mappedBaseColumns);
        this.directMappedBaseColumns = MaterializedViewUtils.transitiveClosure(this.directMappedBaseColumns);
    }

    public Map<String, Map<SchemaTableName, String>> getMaterializedViewColumnMappings() {
        return MaterializedViewColumnMappingExtractor.getColumnMappings(this.analysis, this.mappedBaseColumns);
    }

    public Map<String, Map<SchemaTableName, String>> getMaterializedViewDirectColumnMappings() {
        return MaterializedViewColumnMappingExtractor.getColumnMappings(this.analysis, this.directMappedBaseColumns);
    }

    public List<SchemaTableName> getBaseTablesOnOuterJoinSide() {
        return Collections.unmodifiableList(this.baseTablesOnOuterJoinSide);
    }

    protected Void visitSetOperation(SetOperation node, MaterializedViewPlanValidator.MaterializedViewPlanValidatorContext context) {
        super.visitSetOperation(node, (Object)context);
        List outputDescriptorList = (List)node.getRelations().stream().map(relation -> this.analysis.getOutputDescriptor((Node)relation).withOnlyVisibleFields()).collect(ImmutableList.toImmutableList());
        int numRelations = outputDescriptorList.size();
        int numFields = ((RelationType)outputDescriptorList.get(0)).getVisibleFieldCount();
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            for (int firstRelationIndex = 1; firstRelationIndex < numRelations; ++firstRelationIndex) {
                Optional<ConnectorMaterializedViewDefinition.TableColumn> firstBaseColumn = MaterializedViewColumnMappingExtractor.tryGetOriginalTableColumn(((RelationType)outputDescriptorList.get(firstRelationIndex)).getFieldByIndex(fieldIndex));
                Optional<ConnectorMaterializedViewDefinition.TableColumn> secondBaseColumn = MaterializedViewColumnMappingExtractor.tryGetOriginalTableColumn(((RelationType)outputDescriptorList.get(firstRelationIndex - 1)).getFieldByIndex(fieldIndex));
                if (!firstBaseColumn.isPresent() || !secondBaseColumn.isPresent()) continue;
                this.mappedBaseColumns.computeIfAbsent(firstBaseColumn.get(), k -> new HashSet()).add(secondBaseColumn.get());
                this.mappedBaseColumns.computeIfAbsent(secondBaseColumn.get(), k -> new HashSet()).add(firstBaseColumn.get());
                this.directMappedBaseColumns.computeIfAbsent(firstBaseColumn.get(), k -> new HashSet()).add(secondBaseColumn.get());
                this.directMappedBaseColumns.computeIfAbsent(secondBaseColumn.get(), k -> new HashSet()).add(firstBaseColumn.get());
            }
        }
        return null;
    }

    @Override
    protected Void visitTable(Table node, MaterializedViewPlanValidator.MaterializedViewPlanValidatorContext context) {
        super.visitTable(node, context);
        if (context.isWithinOuterJoin()) {
            this.baseTablesOnOuterJoinSide.add(MetadataUtil.toSchemaTableName(MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName())));
        }
        return null;
    }

    @Override
    protected Void visitComparisonExpression(ComparisonExpression node, MaterializedViewPlanValidator.MaterializedViewPlanValidatorContext context) {
        super.visitComparisonExpression(node, context);
        if (!context.isWithinJoinOn()) {
            return null;
        }
        Field left = ((ResolvedField)this.analysis.getScope((Node)context.getTopJoinNode()).tryResolveField(node.getLeft()).orElseThrow(() -> new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getLeft(), "%s in join criteria is not supported for materialized view.", new Object[]{node.getLeft().getClass().getSimpleName()}))).getField();
        Field right = ((ResolvedField)this.analysis.getScope((Node)context.getTopJoinNode()).tryResolveField(node.getRight()).orElseThrow(() -> new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getRight(), "%s in join criteria is not supported for materialized view.", new Object[]{node.getRight().getClass().getSimpleName()}))).getField();
        Optional<ConnectorMaterializedViewDefinition.TableColumn> leftBaseColumn = MaterializedViewColumnMappingExtractor.tryGetOriginalTableColumn(left);
        Optional<ConnectorMaterializedViewDefinition.TableColumn> rightBaseColumn = MaterializedViewColumnMappingExtractor.tryGetOriginalTableColumn(right);
        if (leftBaseColumn.isPresent() && rightBaseColumn.isPresent()) {
            this.mappedBaseColumns.computeIfAbsent(leftBaseColumn.get(), k -> new HashSet()).add(rightBaseColumn.get());
            this.mappedBaseColumns.computeIfAbsent(rightBaseColumn.get(), k -> new HashSet()).add(leftBaseColumn.get());
            if (context.getTopJoinNode().getType().equals((Object)Join.Type.INNER)) {
                this.directMappedBaseColumns.computeIfAbsent(leftBaseColumn.get(), k -> new HashSet()).add(rightBaseColumn.get());
                this.directMappedBaseColumns.computeIfAbsent(rightBaseColumn.get(), k -> new HashSet()).add(leftBaseColumn.get());
            }
        }
        return null;
    }

    private static Map<String, ConnectorMaterializedViewDefinition.TableColumn> getOriginalColumnsFromAnalysis(Analysis analysis) {
        Query viewQuery = ((CreateMaterializedView)analysis.getStatement()).getQuery();
        return (Map)analysis.getOutputDescriptor((Node)viewQuery).getVisibleFields().stream().filter(field -> field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()).collect(ImmutableMap.toImmutableMap(field -> (String)field.getName().get(), field -> new ConnectorMaterializedViewDefinition.TableColumn(MetadataUtil.toSchemaTableName((QualifiedObjectName)field.getOriginTable().get()), (String)field.getOriginColumnName().get(), true)));
    }

    private static Map<String, Map<SchemaTableName, String>> getColumnMappings(Analysis analysis, Map<ConnectorMaterializedViewDefinition.TableColumn, Set<ConnectorMaterializedViewDefinition.TableColumn>> columnMappings) {
        Preconditions.checkState((boolean)(analysis.getStatement() instanceof CreateMaterializedView), (Object)"Only support the computation of column mappings when analyzing CreateMaterializedView");
        ImmutableMap.Builder fullColumnMappings = ImmutableMap.builder();
        Map<String, ConnectorMaterializedViewDefinition.TableColumn> originalColumnMappings = MaterializedViewColumnMappingExtractor.getOriginalColumnsFromAnalysis(analysis);
        for (Map.Entry<String, ConnectorMaterializedViewDefinition.TableColumn> columnMapping : originalColumnMappings.entrySet()) {
            String viewColumn = columnMapping.getKey();
            ConnectorMaterializedViewDefinition.TableColumn originalBaseColumn = columnMapping.getValue();
            Map fullBaseColumns = (Map)columnMappings.getOrDefault(originalBaseColumn, (Set<ConnectorMaterializedViewDefinition.TableColumn>)ImmutableSet.of((Object)originalBaseColumn)).stream().collect(ImmutableMap.toImmutableMap(e -> e.getTableName(), e -> e.getColumnName()));
            fullColumnMappings.put((Object)viewColumn, (Object)fullBaseColumns);
        }
        return fullColumnMappings.build();
    }

    private static Optional<ConnectorMaterializedViewDefinition.TableColumn> tryGetOriginalTableColumn(Field field) {
        if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
            SchemaTableName table = MetadataUtil.toSchemaTableName((QualifiedObjectName)field.getOriginTable().get());
            String column = (String)field.getOriginColumnName().get();
            return Optional.of(new ConnectorMaterializedViewDefinition.TableColumn(table, column, true));
        }
        return Optional.empty();
    }
}

