/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParameterUtils {
    private ParameterUtils() {
    }

    public static Map<NodeRef<Parameter>, Expression> parameterExtractor(Statement statement, List<Expression> parameters) {
        List parametersList = (List)ParameterExtractor.getParameters(statement).stream().sorted(Comparator.comparing(parameter -> (NodeLocation)parameter.getLocation().get(), Comparator.comparing(NodeLocation::getLineNumber).thenComparing(NodeLocation::getColumnNumber))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<Expression> iterator = parameters.iterator();
        for (Parameter parameter2 : parametersList) {
            builder.put((Object)NodeRef.of((Node)parameter2), (Object)iterator.next());
        }
        return builder.build();
    }
}

