/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.common.Page;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.spiller.SpillCipher;
import com.facebook.presto.spiller.FileHolder;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SpillerStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSingleStreamSpiller
implements SingleStreamSpiller {
    @VisibleForTesting
    static final int BUFFER_SIZE = 4096;
    private final FileHolder targetFile;
    private final Closer closer = Closer.create();
    private final PagesSerde serde;
    private final SpillerStats spillerStats;
    private final SpillContext localSpillContext;
    private final LocalMemoryContext memoryContext;
    private final Optional<SpillCipher> spillCipher;
    private final ListeningExecutorService executor;
    private boolean writable = true;
    private boolean committed;
    private long spilledPagesInMemorySize;
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);

    public FileSingleStreamSpiller(PagesSerde serde, ListeningExecutorService executor, Path spillPath, SpillerStats spillerStats, SpillContext spillContext, LocalMemoryContext memoryContext, Optional<SpillCipher> spillCipher) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats is null");
        this.localSpillContext = spillContext.newLocalSpillContext();
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.spillCipher = Objects.requireNonNull(spillCipher, "spillCipher is null");
        Preconditions.checkState((!spillCipher.isPresent() || !spillCipher.get().isDestroyed() ? 1 : 0) != 0, (Object)"spillCipher is already destroyed");
        this.spillCipher.ifPresent(cipher -> this.closer.register(() -> ((SpillCipher)cipher).destroy()));
        this.memoryContext.setBytes(4096L);
        try {
            this.targetFile = (FileHolder)this.closer.register((Closeable)new FileHolder(Files.createTempFile(spillPath, "spill", ".bin", new FileAttribute[0])));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, String.format("Failed to create spill file: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public ListenableFuture<?> spill(Iterator<Page> pageIterator) {
        Objects.requireNonNull(pageIterator, "pageIterator is null");
        this.checkNoSpillInProgress();
        this.spillInProgress = this.executor.submit(() -> this.writePages(pageIterator));
        return this.spillInProgress;
    }

    @Override
    public long getSpilledPagesInMemorySize() {
        return this.spilledPagesInMemorySize;
    }

    @Override
    public Iterator<Page> getSpilledPages() {
        this.checkNoSpillInProgress();
        return this.readPages();
    }

    @Override
    public ListenableFuture<List<Page>> getAllSpilledPages() {
        return this.executor.submit(() -> ImmutableList.copyOf(this.getSpilledPages()));
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    private void writePages(Iterator<Page> pageIterator) {
        Preconditions.checkState((boolean)this.writable, (Object)"Spilling no longer allowed. The spiller has been made non-writable on first read for subsequent reads to be consistent");
        Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"Spilling no longer allowed. Spill file is already committed");
        try (OutputStreamSliceOutput output = new OutputStreamSliceOutput(this.targetFile.newOutputStream(StandardOpenOption.APPEND), 4096);){
            while (pageIterator.hasNext()) {
                Page page = pageIterator.next();
                this.spilledPagesInMemorySize += page.getSizeInBytes();
                PageSplitterUtil.splitPage(page, 0x100000L).stream().map(arg_0 -> ((PagesSerde)this.serde).serialize(arg_0)).forEach(arg_0 -> this.lambda$writePages$3((SliceOutput)output, arg_0));
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, String.format("Failed to spill pages: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Iterator<Page> readPages() {
        Preconditions.checkState((boolean)this.writable, (Object)"Repeated reads are disallowed to prevent potential resource leaks");
        this.writable = false;
        try {
            if (!this.committed) {
                this.commit();
            }
            Preconditions.checkState((boolean)this.committed, (Object)"Cannot read pages since spill file is not committed");
            InputStream input = (InputStream)this.closer.register((Closeable)this.targetFile.newInputStream(new OpenOption[0]));
            Iterator deserializedPages = PagesSerdeUtil.readPages((PagesSerde)this.serde, (SliceInput)new InputStreamSliceInput(input, 4096));
            Iterator compactPages = Iterators.transform((Iterator)deserializedPages, Page::compact);
            return FileSingleStreamSpiller.closeWhenExhausted(compactPages, input);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, String.format("Failed to read spilled pages: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.closer.register((Closeable)this.localSpillContext);
        this.closer.register(() -> this.memoryContext.setBytes(0L));
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, String.format("Failed to close spiller: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void checkNoSpillInProgress() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone(), (Object)"spill in progress");
    }

    private static <T> Iterator<T> closeWhenExhausted(final Iterator<T> iterator, final Closeable resource) {
        Objects.requireNonNull(iterator, "iterator is null");
        Objects.requireNonNull(resource, "resource is null");
        return new AbstractIterator<T>(){

            protected T computeNext() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                try {
                    resource.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this.endOfData();
            }
        };
    }

    private /* synthetic */ void lambda$writePages$3(SliceOutput output, SerializedPage serializedPage) {
        long pageSize = serializedPage.getSizeInBytes();
        this.localSpillContext.updateBytes(pageSize);
        this.spillerStats.addToTotalSpilledBytes(pageSize);
        PagesSerdeUtil.writeSerializedPage((SliceOutput)output, (SerializedPage)serializedPage);
    }
}

