/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.VarArgsToArrayAdapterGenerator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class MapConcatFunction
extends SqlScalarFunction {
    public static final MapConcatFunction MAP_CONCAT_FUNCTION = new MapConcatFunction();
    private static final String FUNCTION_NAME = "map_concat";
    private static final String DESCRIPTION = "Concatenates given maps";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConcatFunction.class, "mapConcat", MapType.class, Block[].class);

    private MapConcatFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)FUNCTION_NAME), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"K"), (Object)Signature.typeVariable((String)"V")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)")), true));
    }

    public final SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments to map_concat");
        }
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MapType mapType = (MapType)functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        VarArgsToArrayAdapterGenerator.VarArgMethodHandle varArgMethodHandle = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Block.class, Block.class, arity, METHOD_HANDLE.bindTo(mapType));
        return new BuiltInScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), varArgMethodHandle.getMethodHandle());
    }

    @UsedByGeneratedCode
    public static Block mapConcat(MapType mapType, Block[] maps) {
        int lastMapIndex;
        int entries = 0;
        int firstMapIndex = lastMapIndex = maps.length - 1;
        for (int i = 0; i < maps.length; ++i) {
            entries += maps[i].getPositionCount();
            if (maps[i].getPositionCount() <= 0) continue;
            lastMapIndex = i;
            firstMapIndex = Math.min(firstMapIndex, i);
        }
        if (lastMapIndex == firstMapIndex) {
            return maps[lastMapIndex];
        }
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        OptimizedTypedSet typedSet = new OptimizedTypedSet(keyType, maps.length, entries / 2);
        for (int i = lastMapIndex; i >= firstMapIndex; --i) {
            SingleMapBlock singleMapBlock = (SingleMapBlock)maps[i];
            Block keyBlock = singleMapBlock.getKeyBlock();
            typedSet.union(keyBlock);
        }
        List<SelectedPositions> selectedPositionsList = typedSet.getPositionsForBlocks();
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, selectedPositionsList.size());
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = lastMapIndex; i >= firstMapIndex; --i) {
            SingleMapBlock singleMapBlock = (SingleMapBlock)maps[i];
            SelectedPositions selectedPositions = selectedPositionsList.get(lastMapIndex - i);
            assert (selectedPositions.isList());
            int[] positions = selectedPositions.getPositions();
            for (int j = 0; j < selectedPositions.size(); ++j) {
                int position = positions[j];
                keyType.appendTo((Block)singleMapBlock, 2 * position, blockBuilder);
                valueType.appendTo((Block)singleMapBlock, 2 * position + 1, blockBuilder);
            }
        }
        mapBlockBuilder.closeEntry();
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

