/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class JsonPath {
    private final JsonExtract.JsonExtractor<Slice> scalarExtractor;
    private final JsonExtract.JsonExtractor<Slice> objectExtractor;
    private final JsonExtract.JsonExtractor<Long> sizeExtractor;
    private static final ObjectMapper mapper = new ObjectMapper();

    private static JsonExtract.JsonExtractor<Slice> getScalarExtractorForJayway(final com.jayway.jsonpath.JsonPath jsonPath, final Configuration jaywayConfig) {
        return new JsonExtract.JsonExtractor<Slice>(){

            @Override
            public Slice extract(InputStream inputStream) throws IOException {
                JsonNode node = JsonPath.jaywayExtract(jsonPath, jaywayConfig, inputStream);
                if (node == null || !node.isValueNode()) {
                    return null;
                }
                return Slices.utf8Slice((String)node.asText());
            }
        };
    }

    private static JsonExtract.JsonExtractor<Slice> getObjectExtractorForJayway(final com.jayway.jsonpath.JsonPath jsonPath, final Configuration jaywayConfig) {
        return new JsonExtract.JsonExtractor<Slice>(){

            @Override
            public Slice extract(InputStream inputStream) throws IOException {
                JsonNode node = JsonPath.jaywayExtract(jsonPath, jaywayConfig, inputStream);
                if (node == null) {
                    return null;
                }
                return Slices.utf8Slice((String)node.toString());
            }
        };
    }

    private static JsonExtract.JsonExtractor<Long> getSizeExtractorForJayway(final com.jayway.jsonpath.JsonPath jsonPath, final Configuration jaywayConfig) {
        return new JsonExtract.JsonExtractor<Long>(){

            @Override
            public Long extract(InputStream inputStream) throws IOException {
                JsonNode node = JsonPath.jaywayExtract(jsonPath, jaywayConfig, inputStream);
                if (node == null) {
                    return null;
                }
                return node.size();
            }
        };
    }

    private static JsonNode jaywayExtract(com.jayway.jsonpath.JsonPath jsonPath, Configuration jaywayConfig, InputStream inputStream) throws IOException {
        try {
            Object res = jsonPath.read(inputStream, jaywayConfig);
            if (res instanceof JsonNode) {
                return (JsonNode)res;
            }
            return mapper.valueToTree(res);
        }
        catch (InvalidJsonException | PathNotFoundException ex) {
            return null;
        }
    }

    private static JsonPath buildPresto(String pattern) {
        return new JsonPath(JsonExtract.generateExtractor(pattern, new JsonExtract.ScalarValueJsonExtractor()), JsonExtract.generateExtractor(pattern, new JsonExtract.JsonValueJsonExtractor()), JsonExtract.generateExtractor(pattern, new JsonExtract.JsonSizeExtractor()));
    }

    private static JsonPath buildJayway(String pattern) {
        try {
            Configuration jaywayConfig = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
            if (pattern == null || pattern.isEmpty()) {
                throw new InvalidPathException();
            }
            com.jayway.jsonpath.JsonPath jsonPath = com.jayway.jsonpath.JsonPath.compile((String)pattern, (Predicate[])new Predicate[0]);
            return new JsonPath(JsonPath.getScalarExtractorForJayway(jsonPath, jaywayConfig), JsonPath.getObjectExtractorForJayway(jsonPath, jaywayConfig), JsonPath.getSizeExtractorForJayway(jsonPath, jaywayConfig));
        }
        catch (InvalidPathException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid JSON path: '%s'", pattern));
        }
    }

    public static JsonPath build(String pattern) {
        try {
            return JsonPath.buildPresto(pattern);
        }
        catch (PrestoException ex) {
            if (ex.getErrorCode() == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode()) {
                return JsonPath.buildJayway(pattern);
            }
            throw ex;
        }
    }

    public JsonPath(JsonExtract.JsonExtractor<Slice> scalar, JsonExtract.JsonExtractor<Slice> object, JsonExtract.JsonExtractor<Long> size) {
        Objects.requireNonNull(scalar, "scalar extractor is null");
        Objects.requireNonNull(object, "object extractor is null");
        Objects.requireNonNull(size, "size extractor is null");
        this.scalarExtractor = scalar;
        this.objectExtractor = object;
        this.sizeExtractor = size;
    }

    public JsonExtract.JsonExtractor<Slice> getScalarExtractor() {
        return this.scalarExtractor;
    }

    public JsonExtract.JsonExtractor<Slice> getObjectExtractor() {
        return this.objectExtractor;
    }

    public JsonExtract.JsonExtractor<Long> getSizeExtractor() {
        return this.sizeExtractor;
    }
}

