/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_remove")
@Description(value="Remove specified values from the given array")
public final class ArrayRemoveFunction {
    @TypeParameter(value="E")
    public ArrayRemoveFunction(@TypeParameter(value="E") Type elementType) {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") long value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") double value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") boolean value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") Object value) {
        int i;
        int found = -1;
        for (int i2 = 0; i2 < array.getPositionCount(); ++i2) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i2);
            if (element == null) continue;
            try {
                Boolean result = equalsFunction.invoke(element, value);
                if (result == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_remove does not support arrays with elements that are null or contain null");
                }
                if (!result.booleanValue()) continue;
                found = i2;
                break;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (found == -1) {
            return array;
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, array.getPositionCount() - 1);
        for (i = 0; i < found; ++i) {
            type.appendTo(array, i, blockBuilder);
        }
        for (i = found + 1; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i);
            if (element == null) {
                blockBuilder.appendNull();
                continue;
            }
            try {
                Boolean result = equalsFunction.invoke(element, value);
                if (result == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_remove does not support arrays with elements that are null or contain null");
                }
                if (result.booleanValue()) continue;
                type.appendTo(array, i, blockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return blockBuilder.build();
    }
}

