/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.BlockToBooleanFunction;
import com.facebook.presto.operator.scalar.BooleanToBooleanFunction;
import com.facebook.presto.operator.scalar.DoubleToBooleanFunction;
import com.facebook.presto.operator.scalar.LongToBooleanFunction;
import com.facebook.presto.operator.scalar.SliceToBooleanFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;

@Description(value="Return the first element which matches the given predicate, null if no match")
@ScalarFunction(value="find_first", deterministic=true)
public class ArrayFindFirstWithOffsetFunction {
    protected ArrayFindFirstWithOffsetFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Block findBlockWithOffset(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="bigint") long offset, @SqlType(value="function(T, boolean)") BlockToBooleanFunction function) {
        return ArrayFindFirstWithOffsetFunction.findBlockUtil(elementType, arrayBlock, offset, function);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Slice findSliceWithOffset(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="bigint") long offset, @SqlType(value="function(T, boolean)") SliceToBooleanFunction function) {
        return ArrayFindFirstWithOffsetFunction.findSliceUtil(elementType, arrayBlock, offset, function);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long findLongWithOffset(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="bigint") long offset, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        return ArrayFindFirstWithOffsetFunction.findLongUtil(elementType, arrayBlock, offset, function);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double findDoubleWithOffset(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="bigint") long offset, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        return ArrayFindFirstWithOffsetFunction.findDoubleUtil(elementType, arrayBlock, offset, function);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean findBooleanWithOffset(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="bigint") long offset, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        return ArrayFindFirstWithOffsetFunction.findBooleanUtil(elementType, arrayBlock, offset, function);
    }

    public static Block findBlockUtil(Type elementType, Block arrayBlock, long offset, BlockToBooleanFunction function) {
        int startPosition = ArrayFindFirstWithOffsetFunction.checkedIndexToBlockPosition(arrayBlock, offset);
        if (startPosition < 0) {
            return null;
        }
        int increment = offset > 0L ? 1 : -1;
        for (int i = startPosition; i < arrayBlock.getPositionCount() && i >= 0; i += increment) {
            Boolean match;
            Block element = null;
            if (!arrayBlock.isNull(i)) {
                element = (Block)elementType.getObject(arrayBlock, i);
            }
            if (!Boolean.TRUE.equals(match = function.apply(element))) continue;
            return element;
        }
        return null;
    }

    public static Slice findSliceUtil(Type elementType, Block arrayBlock, long offset, SliceToBooleanFunction function) {
        int startPosition = ArrayFindFirstWithOffsetFunction.checkedIndexToBlockPosition(arrayBlock, offset);
        if (startPosition < 0) {
            return null;
        }
        int increment = offset > 0L ? 1 : -1;
        for (int i = startPosition; i < arrayBlock.getPositionCount() && i >= 0; i += increment) {
            Boolean match;
            Slice element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getSlice(arrayBlock, i);
            }
            if (!Boolean.TRUE.equals(match = function.apply(element))) continue;
            return element;
        }
        return null;
    }

    public static Long findLongUtil(Type elementType, Block arrayBlock, long offset, LongToBooleanFunction function) {
        int startPosition = ArrayFindFirstWithOffsetFunction.checkedIndexToBlockPosition(arrayBlock, offset);
        if (startPosition < 0) {
            return null;
        }
        int increment = offset > 0L ? 1 : -1;
        for (int i = startPosition; i < arrayBlock.getPositionCount() && i >= 0; i += increment) {
            Boolean match;
            Long element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getLong(arrayBlock, i);
            }
            if (!Boolean.TRUE.equals(match = function.apply(element))) continue;
            return element;
        }
        return null;
    }

    public static Double findDoubleUtil(Type elementType, Block arrayBlock, long offset, DoubleToBooleanFunction function) {
        int startPosition = ArrayFindFirstWithOffsetFunction.checkedIndexToBlockPosition(arrayBlock, offset);
        if (startPosition < 0) {
            return null;
        }
        int increment = offset > 0L ? 1 : -1;
        for (int i = startPosition; i < arrayBlock.getPositionCount() && i >= 0; i += increment) {
            Boolean match;
            Double element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getDouble(arrayBlock, i);
            }
            if (!Boolean.TRUE.equals(match = function.apply(element))) continue;
            return element;
        }
        return null;
    }

    public static Boolean findBooleanUtil(Type elementType, Block arrayBlock, long offset, BooleanToBooleanFunction function) {
        int startPosition = ArrayFindFirstWithOffsetFunction.checkedIndexToBlockPosition(arrayBlock, offset);
        if (startPosition < 0) {
            return null;
        }
        int increment = offset > 0L ? 1 : -1;
        for (int i = startPosition; i < arrayBlock.getPositionCount() && i >= 0; i += increment) {
            Boolean match;
            Boolean element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getBoolean(arrayBlock, i);
            }
            if (!Boolean.TRUE.equals(match = function.apply(element))) continue;
            return element;
        }
        return null;
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            return -1;
        }
        index = index > 0L ? index - 1L : (long)arrayLength + index;
        return Math.toIntExact(index);
    }
}

