/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PageFieldsToInputParametersRewriter {
    private PageFieldsToInputParametersRewriter() {
    }

    public static Result rewritePageFieldsToInputParameters(RowExpression expression) {
        return PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters((List<RowExpression>)ImmutableList.of((Object)expression));
    }

    public static Result rewritePageFieldsToInputParameters(List<RowExpression> expressions) {
        Visitor visitor = new Visitor();
        List rewrittenExpressions = (List)expressions.stream().map(expression -> (RowExpression)expression.accept((RowExpressionVisitor)visitor, null)).collect(ImmutableList.toImmutableList());
        InputChannels inputChannels = new InputChannels(visitor.getInputChannels());
        return new Result(rewrittenExpressions, inputChannels);
    }

    public static class Result {
        private final List<RowExpression> rewrittenExpressions;
        private final InputChannels inputChannels;

        public Result(List<RowExpression> rewrittenExpressions, InputChannels inputChannels) {
            this.rewrittenExpressions = rewrittenExpressions;
            this.inputChannels = inputChannels;
        }

        public List<RowExpression> getRewrittenExpressions() {
            return this.rewrittenExpressions;
        }

        public RowExpression getRewrittenExpression() {
            Preconditions.checkState((this.rewrittenExpressions.size() == 1 ? 1 : 0) != 0, (Object)"Expect only one expression");
            return this.rewrittenExpressions.get(0);
        }

        public InputChannels getInputChannels() {
            return this.inputChannels;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private final Map<Integer, Integer> fieldToParameter = new HashMap<Integer, Integer>();
        private final List<Integer> inputChannels = new ArrayList<Integer>();
        private int nextParameter;

        private Visitor() {
        }

        public List<Integer> getInputChannels() {
            return ImmutableList.copyOf(this.inputChannels);
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            int parameter = this.getParameterForField(reference);
            return Expressions.field(reference.getSourceLocation(), parameter, reference.getType());
        }

        private Integer getParameterForField(InputReferenceExpression reference) {
            return this.fieldToParameter.computeIfAbsent(reference.getField(), field -> {
                this.inputChannels.add((Integer)field);
                return this.nextParameter++;
            });
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            return new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List)call.getArguments().stream().map(expression -> (RowExpression)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList()));
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getSourceLocation(), lambda.getArgumentTypes(), lambda.getArguments(), (RowExpression)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context));
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            return new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(expression -> (RowExpression)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList()));
        }
    }
}

