/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.index.IndexedData;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexSnapshot
implements IndexedData {
    private static final Page EMPTY_PAGE = new Page(0);
    private final LookupSource values;
    private final LookupSource missingKeys;

    public IndexSnapshot(LookupSource values, LookupSource missingKeys) {
        this.values = Objects.requireNonNull(values, "values is null");
        this.missingKeys = Objects.requireNonNull(missingKeys, "missingKeys is null");
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        long joinPosition = this.values.getJoinPosition(position, page, page);
        if (joinPosition < 0L) {
            if (this.missingKeys.getJoinPosition(position, page, page) < 0L) {
                return -2L;
            }
            return -1L;
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        return this.values.getNextJoinPosition(currentPosition, -1, EMPTY_PAGE);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.values.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

