/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.aggregation.Adder;
import com.facebook.presto.operator.aggregation.MapUnionSumResult;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.MapUnionSumState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.RealOperators;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapUnionSumStateFactory
implements AccumulatorStateFactory<MapUnionSumState> {
    private final Type keyType;
    private final Type valueType;
    private final Adder adder;
    private static final Adder LONG_ADDER = new Adder(){

        @Override
        public void writeSum(Type type, Block block1, int position1, Block block2, int position2, BlockBuilder blockBuilder) {
            type.writeLong(blockBuilder, BigintOperators.add(type.getLong(block1, position1), type.getLong(block2, position2)));
        }
    };
    private static final Adder DOUBLE_ADDER = new Adder(){

        @Override
        public void writeSum(Type type, Block block1, int position1, Block block2, int position2, BlockBuilder blockBuilder) {
            type.writeDouble(blockBuilder, DoubleOperators.add(type.getDouble(block1, position1), type.getDouble(block2, position2)));
        }
    };
    private static final Adder FLOAT_ADDER = new Adder(){

        @Override
        public void writeSum(Type type, Block block1, int position1, Block block2, int position2, BlockBuilder blockBuilder) {
            type.writeLong(blockBuilder, RealOperators.add(type.getLong(block1, position1), type.getLong(block2, position2)));
        }
    };

    public MapUnionSumStateFactory(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.adder = MapUnionSumStateFactory.getAdder(valueType);
    }

    public MapUnionSumState createSingleState() {
        return new SingleState(this.keyType, this.valueType, this.adder);
    }

    public Class<? extends MapUnionSumState> getSingleStateClass() {
        return SingleState.class;
    }

    public MapUnionSumState createGroupedState() {
        return new GroupedState(this.keyType, this.valueType, this.adder);
    }

    public Class<? extends MapUnionSumState> getGroupedStateClass() {
        return GroupedState.class;
    }

    private static Adder getAdder(Type type) {
        if (TypeUtils.isExactNumericType((Type)type)) {
            return LONG_ADDER;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return DOUBLE_ADDER;
        }
        if (RealType.REAL.equals((Object)type)) {
            return FLOAT_ADDER;
        }
        Preconditions.checkState((boolean)false);
        return null;
    }

    public static class SingleState
    implements MapUnionSumState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleState.class).instanceSize();
        private final Type keyType;
        private final Type valueType;
        private final Adder adder;
        private MapUnionSumResult pair;

        public SingleState(Type keyType, Type valueType, Adder adder) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.adder = adder;
        }

        @Override
        public MapUnionSumResult get() {
            return this.pair;
        }

        @Override
        public void set(MapUnionSumResult value) {
            this.pair = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.pair != null) {
                estimatedSize += this.pair.getRetainedSizeInBytes();
            }
            return estimatedSize;
        }

        @Override
        public Adder getAdder() {
            return this.adder;
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements MapUnionSumState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedState.class).instanceSize();
        private final Type keyType;
        private final Type valueType;
        private final Adder adder;
        private final ObjectBigArray<MapUnionSumResult> pairs = new ObjectBigArray();
        private long size;

        public GroupedState(Type keyType, Type valueType, Adder adder) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.adder = adder;
        }

        public void ensureCapacity(long size) {
            this.pairs.ensureCapacity(size);
        }

        @Override
        public MapUnionSumResult get() {
            return (MapUnionSumResult)this.pairs.get(this.getGroupId());
        }

        @Override
        public void set(MapUnionSumResult value) {
            Objects.requireNonNull(value, "value is null");
            MapUnionSumResult previous = this.get();
            if (previous != null) {
                this.size -= previous.getRetainedSizeInBytes();
            }
            this.pairs.set(this.getGroupId(), (Object)value);
            this.size += value.getRetainedSizeInBytes();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.pairs.sizeOf();
        }

        @Override
        public Adder getAdder() {
            return this.adder;
        }
    }
}

