/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.LongBigArray;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.Slice;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongDecimalWithOverflowStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowState> {
    public LongDecimalWithOverflowState createSingleState() {
        return new SingleLongDecimalWithOverflowState();
    }

    public Class<? extends LongDecimalWithOverflowState> getSingleStateClass() {
        return SingleLongDecimalWithOverflowState.class;
    }

    public LongDecimalWithOverflowState createGroupedState() {
        return new GroupedLongDecimalWithOverflowState();
    }

    public Class<? extends LongDecimalWithOverflowState> getGroupedStateClass() {
        return GroupedLongDecimalWithOverflowState.class;
    }

    public static class SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleLongDecimalWithOverflowState.class).instanceSize();
        public static final int SIZE = ClassLayout.parseClass(Slice.class).instanceSize() + 16;
        protected Slice unscaledDecimal;
        protected long overflow;

        @Override
        public Slice getLongDecimal() {
            return this.unscaledDecimal;
        }

        @Override
        public void setLongDecimal(Slice unscaledDecimal) {
            this.unscaledDecimal = unscaledDecimal;
        }

        @Override
        public long getOverflow() {
            return this.overflow;
        }

        @Override
        public void setOverflow(long overflow) {
            this.overflow = overflow;
        }

        @Override
        public void addOverflow(long overflow) {
            this.overflow += overflow;
        }

        public long getEstimatedSize() {
            if (this.getLongDecimal() == null) {
                return INSTANCE_SIZE;
            }
            return INSTANCE_SIZE + SIZE;
        }
    }

    public static class GroupedLongDecimalWithOverflowState
    extends AbstractGroupedAccumulatorState
    implements LongDecimalWithOverflowState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedLongDecimalWithOverflowState.class).instanceSize();
        protected final ObjectBigArray<Slice> unscaledDecimals = new ObjectBigArray();
        @Nullable
        protected LongBigArray overflows;
        protected long numberOfElements;

        public void ensureCapacity(long size) {
            this.unscaledDecimals.ensureCapacity(size);
            if (this.overflows != null) {
                this.overflows.ensureCapacity(size);
            }
        }

        @Override
        public Slice getLongDecimal() {
            return (Slice)this.unscaledDecimals.get(this.getGroupId());
        }

        @Override
        public void setLongDecimal(Slice value) {
            Objects.requireNonNull(value, "value is null");
            if (this.unscaledDecimals.getAndSet(this.getGroupId(), (Object)value) == null) {
                ++this.numberOfElements;
            }
        }

        @Override
        public long getOverflow() {
            if (this.overflows == null) {
                return 0L;
            }
            return this.overflows.get(this.getGroupId());
        }

        @Override
        public void setOverflow(long overflow) {
            if (overflow == 0L && this.overflows == null) {
                return;
            }
            long groupId = this.getGroupId();
            if (this.overflows == null) {
                this.overflows = new LongBigArray();
                this.overflows.ensureCapacity(this.unscaledDecimals.getCapacity());
            }
            this.overflows.set(groupId, overflow);
        }

        @Override
        public void addOverflow(long overflow) {
            if (overflow == 0L) {
                return;
            }
            long groupId = this.getGroupId();
            if (this.overflows == null) {
                this.overflows = new LongBigArray();
                this.overflows.ensureCapacity(this.unscaledDecimals.getCapacity());
            }
            this.overflows.add(groupId, overflow);
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.unscaledDecimals.sizeOf() + this.numberOfElements * (long)SingleLongDecimalWithOverflowState.SIZE + (this.overflows == null ? 0L : this.overflows.sizeOf());
        }
    }
}

