/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.minmaxby;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.minmaxby.TwoNullableValueStateMapping;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public abstract class AbstractMinMaxBy
extends SqlAggregationFunction {
    private final boolean min;

    protected AbstractMinMaxBy(boolean min) {
        super((min ? "min" : "max") + "_by", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter((String)"K"), (Object)Signature.typeVariable((String)"V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"V"), (Object)TypeSignature.parseTypeSignature((String)"K")));
        this.min = min;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        return this.generateAggregation(valueType, keyType, functionAndTypeManager);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(Type valueType, Type keyType, FunctionAndTypeManager functionAndTypeManager) {
        Object stateSerializer;
        AccumulatorStateFactory<? extends AccumulatorState> stateFactory;
        Class<? extends AccumulatorState> stateClazz = TwoNullableValueStateMapping.getStateClass(keyType.getJavaType(), valueType.getJavaType());
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        if (valueType.getJavaType().isPrimitive()) {
            ImmutableMap stateFieldTypes = ImmutableMap.of((Object)"First", (Object)keyType, (Object)"Second", (Object)valueType);
            stateFactory = StateCompiler.generateStateFactory(stateClazz, (Map<String, Type>)stateFieldTypes, classLoader);
            stateSerializer = StateCompiler.generateStateSerializer(stateClazz, (Map<String, Type>)stateFieldTypes, classLoader);
        } else {
            stateFactory = StateCompiler.generateStateFactory(stateClazz, (Map<String, Type>)ImmutableMap.of((Object)"First", (Object)keyType, (Object)"SecondBlock", (Object)new ArrayType(valueType)), classLoader);
            stateSerializer = TwoNullableValueStateMapping.getStateSerializer(keyType, valueType);
        }
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        Type intermediateType = this.overrideIntermediateType((List<Type>)inputTypes, stateSerializer.getSerializedType());
        CallSiteBinder binder = new CallSiteBinder();
        OperatorType operator = this.min ? OperatorType.LESS_THAN : OperatorType.GREATER_THAN;
        MethodHandle compareMethod = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(operator, TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, keyType}))).getMethodHandle();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("processMaxOrMinBy"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        this.generateInputMethod(definition, binder, compareMethod, keyType, valueType, stateClazz);
        this.generateCombineMethod(definition, binder, compareMethod, keyType, valueType, stateClazz);
        this.generateOutputMethod(definition, binder, valueType, stateClazz);
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)classLoader);
        MethodHandle inputMethod = Reflection.methodHandle(generatedClass, "input", stateClazz, Block.class, Block.class, Integer.TYPE);
        MethodHandle combineMethod = Reflection.methodHandle(generatedClass, "combine", stateClazz, stateClazz);
        MethodHandle outputMethod = Reflection.methodHandle(generatedClass, "output", stateClazz, BlockBuilder.class);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getNameSuffix(), valueType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), AbstractMinMaxBy.createInputParameterMetadata(valueType, keyType), inputMethod, combineMethod, outputMethod, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateClazz, stateSerializer, stateFactory)), valueType);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(this.getSignature().getNameSuffix(), (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), valueType, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    protected Type overrideIntermediateType(List<Type> inputTypes, Type defaultIntermediateType) {
        return defaultIntermediateType;
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    private void generateInputMethod(ClassDefinition definition, CallSiteBinder binder, MethodHandle compareMethod, Type keyType, Type valueType, Class<?> stateClass) {
        BytecodeExpression setValueNode;
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter value = Parameter.arg((String)"value", Block.class);
        Parameter key = Parameter.arg((String)"key", Block.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "input", ParameterizedType.type(Void.TYPE), new Parameter[]{state, value, key, position});
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock ifBlock = new BytecodeBlock().append((BytecodeNode)state.invoke("setFirst", Void.TYPE, new BytecodeExpression[]{keySqlType.getValue((BytecodeExpression)key, (BytecodeExpression)position)})).append((BytecodeNode)state.invoke("setFirstNull", Void.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantBoolean((boolean)false)})).append((BytecodeNode)state.invoke("setSecondNull", Void.TYPE, new BytecodeExpression[]{value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})}));
        if (valueType.getJavaType().isPrimitive()) {
            SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
            setValueNode = state.invoke("setSecond", Void.TYPE, new BytecodeExpression[]{valueSqlType.getValue((BytecodeExpression)value, (BytecodeExpression)position)});
        } else {
            setValueNode = new BytecodeBlock().append((BytecodeNode)state.invoke("setSecondBlock", Void.TYPE, new BytecodeExpression[]{value})).append((BytecodeNode)state.invoke("setSecondPosition", Void.TYPE, new BytecodeExpression[]{position}));
        }
        ifBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifFalse((BytecodeNode)setValueNode));
        method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)key.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})), (BytecodeExpression)BytecodeUtils.loadConstant(binder, compareMethod, MethodHandle.class).invoke("invokeExact", Boolean.TYPE, new BytecodeExpression[]{keySqlType.getValue((BytecodeExpression)key, (BytecodeExpression)position), state.invoke("getFirst", keyType.getJavaType(), new BytecodeExpression[0])})))).ifTrue((BytecodeNode)ifBlock)).ret();
    }

    private void generateCombineMethod(ClassDefinition definition, CallSiteBinder binder, MethodHandle compareMethod, Type keyType, Type valueType, Class<?> stateClass) {
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter otherState = Parameter.arg((String)"otherState", stateClass);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "combine", ParameterizedType.type(Void.TYPE), new Parameter[]{state, otherState});
        Class keyJavaType = keyType.getJavaType();
        BytecodeBlock ifBlock = new BytecodeBlock().append((BytecodeNode)state.invoke("setFirst", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getFirst", keyJavaType, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setFirstNull", Void.TYPE, new BytecodeExpression[]{otherState.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setSecondNull", Void.TYPE, new BytecodeExpression[]{otherState.invoke("isSecondNull", Boolean.TYPE, new BytecodeExpression[0])}));
        if (valueType.getJavaType().isPrimitive()) {
            ifBlock.append((BytecodeNode)state.invoke("setSecond", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecond", valueType.getJavaType(), new BytecodeExpression[0])}));
        } else {
            ifBlock.append((BytecodeNode)new BytecodeBlock().append((BytecodeNode)state.invoke("setSecondBlock", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecondBlock", Block.class, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setSecondPosition", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecondPosition", Integer.TYPE, new BytecodeExpression[0])})));
        }
        method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)otherState.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0])), (BytecodeExpression)BytecodeUtils.loadConstant(binder, compareMethod, MethodHandle.class).invoke("invokeExact", Boolean.TYPE, new BytecodeExpression[]{otherState.invoke("getFirst", keyJavaType, new BytecodeExpression[0]), state.invoke("getFirst", keyJavaType, new BytecodeExpression[0])})))).ifTrue((BytecodeNode)ifBlock)).ret();
    }

    private void generateOutputMethod(ClassDefinition definition, CallSiteBinder binder, Type valueType, Class<?> stateClass) {
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "output", ParameterizedType.type(Void.TYPE), new Parameter[]{state, out});
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)state.invoke("isSecondNull", Boolean.TYPE, new BytecodeExpression[0]))).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0])).pop());
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        BytecodeExpression getValueExpression = valueType.getJavaType().isPrimitive() ? state.invoke("getSecond", valueType.getJavaType(), new BytecodeExpression[0]) : valueSqlType.getValue(state.invoke("getSecondBlock", Block.class, new BytecodeExpression[0]), state.invoke("getSecondPosition", Integer.TYPE, new BytecodeExpression[0]));
        ifStatement.ifFalse((BytecodeNode)valueSqlType.writeValue((BytecodeExpression)out, getValueExpression));
        method.getBody().append((BytecodeNode)ifStatement).ret();
    }
}

