/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public class FixedHistogramStateStrategyUtils {
    private FixedHistogramStateStrategyUtils() {
    }

    public static void validateParameters(long bucketCount, double min, double max) {
        if (bucketCount < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, bucket count must be non-negative: %s", bucketCount));
        }
        if (min >= max) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, min must be larger than max: min=%s, max=%s", min, max));
        }
    }

    public static void validateParameters(long histogramBucketCount, double histogramMin, double histogramMax, long bucketCount, double sample, double weight, double min, double max) {
        FixedHistogramStateStrategyUtils.validateParameters(histogramBucketCount, histogramMin, histogramMax);
        FixedHistogramStateStrategyUtils.validateParameters(bucketCount, min, max);
        if (weight < 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, weight must be non-negative: %s", weight));
        }
        if (histogramBucketCount != bucketCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent bucket count: prev=%s, current=%s", histogramBucketCount, bucketCount));
        }
        if (histogramMin != min) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent min: prev=%s, current=%s", histogramMin, min));
        }
        if (histogramMax != max) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent max: prev=%s, current=%s", histogramMax, max));
        }
        if (sample < min) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, sample must be at least min: sample=%s, min=%s", sample, min));
        }
        if (sample > max) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, sample must be at most max: sample=%s, max=%s", sample, max));
        }
    }

    public static double getXLogX(double x) {
        return x <= 0.0 ? 0.0 : x * Math.log(x);
    }
}

