/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationState;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationStateConsumer;
import com.google.common.base.Verify;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleArrayAggregationState
implements ArrayAggregationState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleArrayAggregationState.class).instanceSize();
    private BlockBuilder blockBuilder;
    private final Type type;

    public SingleArrayAggregationState(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.blockBuilder != null) {
            estimatedSize += this.blockBuilder.getRetainedSizeInBytes();
        }
        return estimatedSize;
    }

    @Override
    public void add(Block block, int position) {
        if (this.blockBuilder == null) {
            this.blockBuilder = this.type.createBlockBuilder(null, 16);
        }
        this.type.appendTo(block, position, this.blockBuilder);
    }

    @Override
    public void forEach(ArrayAggregationStateConsumer consumer) {
        if (this.blockBuilder == null) {
            return;
        }
        for (int i = 0; i < this.blockBuilder.getPositionCount(); ++i) {
            consumer.accept((Block)this.blockBuilder, i);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blockBuilder == null) {
            return true;
        }
        Verify.verify((this.blockBuilder.getPositionCount() != 0 ? 1 : 0) != 0);
        return false;
    }

    @Override
    public void reset() {
        this.blockBuilder = null;
    }
}

