/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class OptimizedTypedSet {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedSet.class).instanceSize();
    private static final int ARRAY_LIST_INSTANCE_SIZE = ClassLayout.parseClass(ArrayList.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private static final int INVALID_POSITION = -1;
    private static final int INITIAL_BLOCK_COUNT = 2;
    private static final SelectedPositions EMPTY_SELECTED_POSITIONS = SelectedPositions.positionsList(new int[0], 0, 0);
    private final Type elementType;
    private final int hashCapacity;
    private final int hashMask;
    private int size;
    private Block[] blocks;
    private List<SelectedPositions> positionsForBlocks;
    private long[] blockPositionByHash;
    private int currentBlockIndex = -1;

    public OptimizedTypedSet(Type elementType, int maxPositionCount) {
        this(elementType, 2, maxPositionCount);
    }

    public OptimizedTypedSet(Type elementType, int expectedBlockCount, int maxPositionCount) {
        Preconditions.checkArgument((expectedBlockCount >= 0 ? 1 : 0) != 0, (Object)"expectedBlockCount must not be negative");
        Preconditions.checkArgument((maxPositionCount >= 0 ? 1 : 0) != 0, (Object)"maxPositionCount must not be negative");
        this.elementType = Objects.requireNonNull(elementType, "elementType must not be null");
        this.hashCapacity = HashCommon.arraySize((int)maxPositionCount, (float)0.75f);
        this.hashMask = this.hashCapacity - 1;
        this.blocks = new Block[expectedBlockCount];
        this.positionsForBlocks = new ArrayList<SelectedPositions>(expectedBlockCount);
        this.blockPositionByHash = this.initializeHashTable();
    }

    public void union(Block block) {
        ++this.currentBlockIndex;
        this.ensureBlocksCapacity(this.currentBlockIndex + 1);
        this.blocks[this.currentBlockIndex] = block;
        int positionCount = block.getPositionCount();
        int[] positions = new int[positionCount];
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int hashPosition = this.getInsertPosition(this.blockPositionByHash, this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, i)), block, i);
            if (hashPosition == -1) continue;
            this.addElement(this.blockPositionByHash, hashPosition, block, i);
            positions[positionsIndex++] = i;
        }
        this.getPositionsForBlocks().add(SelectedPositions.positionsList(positions, 0, positionsIndex));
        this.size += positionsIndex;
    }

    public void intersect(Block block) {
        ++this.currentBlockIndex;
        this.ensureBlocksCapacity(this.currentBlockIndex + 1);
        this.blocks[this.currentBlockIndex] = block;
        if (this.currentBlockIndex == 0) {
            this.positionsForBlocks.add(EMPTY_SELECTED_POSITIONS);
            return;
        }
        int positionCount = block.getPositionCount();
        int[] positions = com.facebook.presto.common.array.Arrays.ensureCapacity((int[])this.positionsForBlocks.get(this.currentBlockIndex - 1).getPositions(), (int)positionCount);
        long[] newBlockPositionByHash = this.initializeHashTable();
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int hash = this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, i));
            int positionInBlockPositionByHash = this.getInsertPosition(this.blockPositionByHash, hash, block, i);
            if (positionInBlockPositionByHash != -1 || !this.addElement(newBlockPositionByHash, hash, block, i)) continue;
            positions[positionsIndex++] = i;
        }
        this.blockPositionByHash = newBlockPositionByHash;
        this.getPositionsForBlocks().add(SelectedPositions.positionsList(positions, 0, positionsIndex));
        this.size = positionsIndex;
        this.clearPreviousBlocks();
    }

    public void except(Block block) {
        int positionCount = block.getPositionCount();
        if (this.currentBlockIndex == -1) {
            this.union(block);
            return;
        }
        ++this.currentBlockIndex;
        this.ensureBlocksCapacity(this.currentBlockIndex + 1);
        this.blocks[this.currentBlockIndex] = block;
        int[] positions = new int[positionCount];
        long[] newBlockPositionByHash = this.initializeHashTable();
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int hash = this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, i));
            int positionInBlockPositionByHash = this.getInsertPosition(this.blockPositionByHash, hash, block, i);
            if (positionInBlockPositionByHash == -1 || !this.addElement(newBlockPositionByHash, hash, block, i)) continue;
            positions[positionsIndex++] = i;
        }
        this.blockPositionByHash = newBlockPositionByHash;
        this.getPositionsForBlocks().add(SelectedPositions.positionsList(positions, 0, positionsIndex));
        this.size = positionsIndex;
        this.clearPreviousBlocks();
    }

    public Block getBlock() {
        if (this.size == 0) {
            return this.elementType.createBlockBuilder(null, 0).build();
        }
        if (this.currentBlockIndex == 0) {
            Block block = this.blocks[this.currentBlockIndex];
            SelectedPositions selectedPositions = this.getPositionsForBlocks().get(this.currentBlockIndex);
            return new DictionaryBlock(selectedPositions.getOffset(), selectedPositions.size(), block, selectedPositions.getPositions(), false, DictionaryId.randomDictionaryId());
        }
        Block firstBlock = this.blocks[0];
        BlockBuilder blockBuilder = this.elementType.createBlockBuilder(null, this.size, Math.toIntExact(firstBlock.getApproximateRegionLogicalSizeInBytes(0, firstBlock.getPositionCount()) / (long)Math.max(1, Math.toIntExact(firstBlock.getPositionCount()))));
        for (int i = 0; i <= this.currentBlockIndex; ++i) {
            Block block = this.blocks[i];
            SelectedPositions selectedPositions = this.getPositionsForBlocks().get(i);
            int positionCount = selectedPositions.size();
            if (!selectedPositions.isList()) {
                if (positionCount == block.getPositionCount()) {
                    return block;
                }
                return block.getRegion(selectedPositions.getOffset(), positionCount);
            }
            int[] positions = selectedPositions.getPositions();
            for (int j = 0; j < positionCount; ++j) {
                int position = positions[j];
                if (block.isNull(position)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.elementType.appendTo(block, position, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    public List<SelectedPositions> getPositionsForBlocks() {
        return this.positionsForBlocks;
    }

    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)(INSTANCE_SIZE + ARRAY_LIST_INSTANCE_SIZE) + SizeOf.sizeOf((long[])this.blockPositionByHash);
        for (int i = 0; i <= this.currentBlockIndex; ++i) {
            sizeInBytes += SizeOf.sizeOf((int[])this.positionsForBlocks.get(i).getPositions());
        }
        return sizeInBytes;
    }

    private long[] initializeHashTable() {
        long[] newBlockPositionByHash = new long[this.hashCapacity];
        Arrays.fill(newBlockPositionByHash, -1L);
        return newBlockPositionByHash;
    }

    private void ensureBlocksCapacity(int capacity) {
        if (this.blocks == null || this.blocks.length < capacity) {
            this.blocks = Arrays.copyOf(this.blocks, capacity);
        }
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }

    private int getInsertPosition(long[] hashtable, int hashPosition, Block block, int position) {
        long blockPosition;
        while ((blockPosition = hashtable[hashPosition]) != -1L) {
            int blockIndex = (int)((blockPosition & 0xFFFFFFFF00000000L) >> 32);
            int positionWithinBlock = (int)(blockPosition & 0xFFFFFFFFFFFFFFFFL);
            if (TypeUtils.positionEqualsPosition(this.elementType, this.blocks[blockIndex], positionWithinBlock, block, position)) {
                return -1;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private boolean addElement(long[] hashtable, int hashPosition, Block block, int position) {
        while (true) {
            long blockPosition;
            if ((blockPosition = hashtable[hashPosition]) == -1L) {
                hashtable[hashPosition] = (long)this.currentBlockIndex << 32 | (long)position;
                return true;
            }
            int blockIndex = (int)((blockPosition & 0xFFFFFFFF00000000L) >> 32);
            int positionWithinBlock = (int)(blockPosition & 0xFFFFFFFFFFFFFFFFL);
            if (TypeUtils.positionEqualsPosition(this.elementType, this.blocks[blockIndex], positionWithinBlock, block, position)) {
                return false;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
    }

    private void clearPreviousBlocks() {
        for (int i = 0; i < this.currentBlockIndex; ++i) {
            this.positionsForBlocks.set(i, EMPTY_SELECTED_POSITIONS);
        }
    }
}

