/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.state.BlockPositionState;
import com.facebook.presto.operator.aggregation.state.BlockPositionStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public abstract class AbstractMinMaxAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle LONG_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableLongState.class, Long.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableDoubleState.class, Double.TYPE);
    private static final MethodHandle BOOLEAN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableBooleanState.class, Boolean.TYPE);
    private static final MethodHandle BLOCK_POSITION_MIN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "minInput", Type.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle BLOCK_POSITION_MAX_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "maxInput", Type.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_POSITION_OUTPUT_FUNCTION = Reflection.methodHandle(BlockPositionState.class, "write", Type.class, BlockPositionState.class, BlockBuilder.class);
    private static final MethodHandle LONG_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableLongState.class, NullableLongState.class);
    private static final MethodHandle DOUBLE_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableDoubleState.class, NullableDoubleState.class);
    private static final MethodHandle BOOLEAN_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableBooleanState.class, NullableBooleanState.class);
    private static final MethodHandle BLOCK_POSITION_MIN_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "minCombine", Type.class, BlockPositionState.class, BlockPositionState.class);
    private static final MethodHandle BLOCK_POSITION_MAX_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "maxCombine", Type.class, BlockPositionState.class, BlockPositionState.class);
    private final OperatorType operatorType;
    private final boolean min;

    protected AbstractMinMaxAggregationFunction(String name, boolean min) {
        super(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter((String)"E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"E"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"E")));
        this.min = min;
        this.operatorType = min ? OperatorType.LESS_THAN : OperatorType.GREATER_THAN;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = boundVariables.getTypeVariable("E");
        MethodHandle compareMethodHandle = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(this.operatorType, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type}))).getMethodHandle();
        return this.generateAggregation(type, compareMethodHandle);
    }

    protected BuiltInAggregationFunctionImplementation generateAggregation(Type type, MethodHandle compareMethodHandle) {
        MethodHandle outputFunction;
        MethodHandle combineFunction;
        MethodHandle inputFunction;
        BlockPositionStateSerializer stateSerializer;
        Class stateInterface;
        DynamicClassLoader classLoader = new DynamicClassLoader(AbstractMinMaxAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        if (type.getJavaType() == Long.TYPE) {
            stateInterface = NullableLongState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = LONG_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = LONG_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = LONG_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Double.TYPE) {
            stateInterface = NullableDoubleState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = DOUBLE_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = DOUBLE_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = DOUBLE_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Boolean.TYPE) {
            stateInterface = NullableBooleanState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = BOOLEAN_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = BOOLEAN_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = BOOLEAN_OUTPUT_FUNCTION.bindTo(type);
        } else {
            stateInterface = BlockPositionState.class;
            stateSerializer = new BlockPositionStateSerializer(type);
            inputFunction = this.min ? BLOCK_POSITION_MIN_INPUT_FUNCTION.bindTo(type) : BLOCK_POSITION_MAX_INPUT_FUNCTION.bindTo(type);
            combineFunction = this.min ? BLOCK_POSITION_MIN_COMBINE_FUNCTION.bindTo(type) : BLOCK_POSITION_MAX_COMBINE_FUNCTION.bindTo(type);
            outputFunction = BLOCK_POSITION_OUTPUT_FUNCTION.bindTo(type);
        }
        AccumulatorStateFactory<NullableLongState> stateFactory = StateCompiler.generateStateFactory(stateInterface, classLoader);
        Type intermediateType = this.overrideIntermediateType(type, stateSerializer.getSerializedType());
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getNameSuffix(), type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), AbstractMinMaxAggregationFunction.createParameterMetadata(type), inputFunction, combineFunction, outputFunction, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, (AccumulatorStateSerializer)stateSerializer, stateFactory)), type);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(this.getSignature().getNameSuffix(), (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), type, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    protected Type overrideIntermediateType(Type inputType, Type defaultIntermediateType) {
        return defaultIntermediateType;
    }

    private static List<AggregationMetadata.ParameterMetadata> createParameterMetadata(Type type) {
        if (type.getJavaType().isPrimitive()) {
            return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, type));
        }
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(MethodHandle methodHandle, NullableDoubleState state, double value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    public static void input(MethodHandle methodHandle, NullableLongState state, long value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    public static void input(MethodHandle methodHandle, NullableBooleanState state, boolean value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    public static void minInput(Type type, BlockPositionState state, Block block, int position) {
        if (state.getBlock() == null || type.compareTo(block, position, state.getBlock(), state.getPosition()) < 0) {
            state.setBlock(block);
            state.setPosition(position);
        }
    }

    public static void maxInput(Type type, BlockPositionState state, Block block, int position) {
        if (state.getBlock() == null || type.compareTo(block, position, state.getBlock(), state.getPosition()) > 0) {
            state.setBlock(block);
            state.setPosition(position);
        }
    }

    public static void combine(MethodHandle methodHandle, NullableLongState state, NullableLongState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getLong());
    }

    public static void combine(MethodHandle methodHandle, NullableDoubleState state, NullableDoubleState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getDouble());
    }

    public static void combine(MethodHandle methodHandle, NullableBooleanState state, NullableBooleanState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getBoolean());
    }

    public static void minCombine(Type type, BlockPositionState state, BlockPositionState otherState) {
        if (state.getBlock() == null || type.compareTo(otherState.getBlock(), otherState.getPosition(), state.getBlock(), state.getPosition()) < 0) {
            state.setBlock(otherState.getBlock());
            state.setPosition(otherState.getPosition());
        }
    }

    public static void maxCombine(Type type, BlockPositionState state, BlockPositionState otherState) {
        if (state.getBlock() == null || type.compareTo(otherState.getBlock(), otherState.getPosition(), state.getBlock(), state.getPosition()) > 0) {
            state.setBlock(otherState.getBlock());
            state.setPosition(otherState.getPosition());
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableLongState state, long value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getLong())) {
                state.setLong(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableDoubleState state, double value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getDouble())) {
                state.setDouble(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableBooleanState state, boolean value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getBoolean())) {
                state.setBoolean(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

