/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UncheckedByteArrays {
    private static final Unsafe unsafe;

    public static byte getByteUnchecked(byte[] bytes, int index) {
        return unsafe.getByte(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static int setByteUnchecked(byte[] bytes, int index, byte value) {
        unsafe.putByte(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
        return index + Unsafe.ARRAY_BYTE_INDEX_SCALE;
    }

    public static short getShortUnchecked(byte[] bytes, int index) {
        return unsafe.getShort(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static int setShortUnchecked(byte[] bytes, int index, short value) {
        unsafe.putShort(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
        return index + Unsafe.ARRAY_SHORT_INDEX_SCALE;
    }

    public static int getIntUnchecked(byte[] bytes, int index) {
        return unsafe.getInt(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static int setIntUnchecked(byte[] bytes, int index, int value) {
        unsafe.putInt(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
        return index + Unsafe.ARRAY_INT_INDEX_SCALE;
    }

    public static long getLongUnchecked(byte[] bytes, int index) {
        return unsafe.getLong(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static int setLongUnchecked(byte[] bytes, int index, long value) {
        unsafe.putLong(bytes, (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
        return index + Unsafe.ARRAY_LONG_INDEX_SCALE;
    }

    private UncheckedByteArrays() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

