/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.execution.warnings.WarningHandlingLevel;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.ConstantExpressionVerifier;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.StatementUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class QueryPreparer {
    private final SqlParser sqlParser;

    @Inject
    public QueryPreparer(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public PreparedQuery prepareQuery(Session session, String query, WarningCollector warningCollector) throws ParsingException, PrestoException, SemanticException {
        Statement wrappedStatement = this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions(session, warningCollector));
        if (warningCollector.hasWarnings() && SystemSessionProperties.getWarningHandlingLevel(session) == WarningHandlingLevel.AS_ERROR) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.WARNING_AS_ERROR, String.format("Warning handling level set to AS_ERROR. Warnings: %n %s", warningCollector.getWarnings().stream().map(PrestoWarning::getMessage).collect(Collectors.joining(System.lineSeparator()))));
        }
        return this.prepareQuery(session, wrappedStatement, warningCollector);
    }

    public PreparedQuery prepareQuery(Session session, Statement wrappedStatement, WarningCollector warningCollector) throws ParsingException, PrestoException, SemanticException {
        Statement innerStatement;
        Optional<QueryType> innerQueryType;
        Statement statement = wrappedStatement;
        Optional<Object> prepareSql = Optional.empty();
        if (statement instanceof Execute) {
            prepareSql = Optional.of(session.getPreparedStatementFromExecute((Execute)statement));
            statement = this.sqlParser.createStatement((String)prepareSql.get(), ParsingUtil.createParsingOptions(session, warningCollector));
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze() && (!(innerQueryType = StatementUtils.getQueryType((innerStatement = ((Explain)statement).getStatement()).getClass())).isPresent() || innerQueryType.get() == QueryType.DATA_DEFINITION)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE doesn't support statement type: " + innerStatement.getClass().getSimpleName());
        }
        Object parameters = ImmutableList.of();
        if (wrappedStatement instanceof Execute) {
            parameters = ((Execute)wrappedStatement).getParameters();
        }
        QueryPreparer.validateParameters(statement, (List<Expression>)parameters);
        Optional<String> formattedQuery = Optional.empty();
        if (SystemSessionProperties.isLogFormattedQueryEnabled(session)) {
            formattedQuery = Optional.of(QueryPreparer.getFormattedQuery(statement, (List<Expression>)parameters));
        }
        return new PreparedQuery(statement, (List<Expression>)parameters, formattedQuery, prepareSql);
    }

    private static String getFormattedQuery(Statement statement, List<Expression> parameters) {
        String formattedQuery = SqlFormatter.formatSql((Node)statement, parameters.isEmpty() ? Optional.empty() : Optional.of(parameters));
        return String.format("-- Formatted Query:%n%s", formattedQuery);
    }

    private static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", new Object[]{parameterCount, parameterValues.size()});
        }
        for (Expression expression : parameterValues) {
            ConstantExpressionVerifier.verifyExpressionIsConstant((Set)ImmutableSet.of(), (Expression)expression);
        }
    }

    public static class PreparedQuery {
        private final Statement statement;
        private final List<Expression> parameters;
        private final Optional<String> formattedQuery;
        private final Optional<String> prepareSql;

        public PreparedQuery(Statement statement, List<Expression> parameters, Optional<String> formattedQuery, Optional<String> prepareSql) {
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
            this.formattedQuery = Objects.requireNonNull(formattedQuery, "formattedQuery is null");
            this.prepareSql = Objects.requireNonNull(prepareSql, "prepareSql is null");
        }

        public Statement getStatement() {
            return this.statement;
        }

        public List<Expression> getParameters() {
            return this.parameters;
        }

        public Optional<String> getFormattedQuery() {
            return this.formattedQuery;
        }

        public Optional<String> getPrepareSql() {
            return this.prepareSql;
        }
    }
}

