/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.Column;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Input {
    private final ConnectorId connectorId;
    private final String schema;
    private final String table;
    private final List<Column> columns;
    private final Optional<Object> connectorInfo;
    private final Optional<TableStatistics> statistics;
    private final String serializedCommitOutput;

    @JsonCreator
    public Input(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="connectorInfo") Optional<Object> connectorInfo, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="statistics") Optional<TableStatistics> statistics, @JsonProperty(value="serializedCommitOutput") String serializedCommitOutput) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.connectorInfo = Objects.requireNonNull(connectorInfo, "connectorInfo is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.statistics = Objects.requireNonNull(statistics, "table statistics is null");
        this.serializedCommitOutput = Objects.requireNonNull(serializedCommitOutput, "serializedCommitOutput is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<Object> getConnectorInfo() {
        return this.connectorInfo;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<TableStatistics> getStatistics() {
        return this.statistics;
    }

    @JsonProperty
    public String getSerializedCommitOutput() {
        return this.serializedCommitOutput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.connectorId, input.connectorId) && Objects.equals(this.schema, input.schema) && Objects.equals(this.table, input.table) && Objects.equals(this.columns, input.columns) && Objects.equals(this.connectorInfo, input.connectorInfo) && Objects.equals(this.statistics, input.statistics) && Objects.equals(this.serializedCommitOutput, input.serializedCommitOutput);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schema, this.table, this.columns, this.connectorInfo, this.statistics, this.serializedCommitOutput);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.connectorId).addValue((Object)this.schema).addValue((Object)this.table).addValue(this.columns).addValue(this.statistics).addValue((Object)this.serializedCommitOutput).toString();
    }
}

