/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.execution.DataDefinitionExecution;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DDLDefinitionExecution<T extends Statement>
extends DataDefinitionExecution<T> {
    private final DDLDefinitionTask<T> task;

    private DDLDefinitionExecution(DDLDefinitionTask<T> task, T statement, String slug, int retryCount, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        super(statement, slug, retryCount, transactionManager, metadata, accessControl, stateMachine, parameters);
        this.task = Objects.requireNonNull(task, "task is null");
    }

    @Override
    protected ListenableFuture<?> executeTask() {
        return this.task.execute(this.statement, this.transactionManager, this.metadata, this.accessControl, this.stateMachine.getSession(), this.parameters, this.stateMachine.getWarningCollector());
    }

    /* synthetic */ DDLDefinitionExecution(DDLDefinitionTask x0, Statement x1, String x2, int x3, TransactionManager x4, Metadata x5, AccessControl x6, QueryStateMachine x7, List x8, 1 x9) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8);
    }

    public static class DDLDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DDLDefinitionExecution<?>> {
        private final TransactionManager transactionManager;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DDLDefinitionExecutionFactory(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        @Override
        public DDLDefinitionExecution<?> createQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount, WarningCollector warningCollector, Optional<QueryType> queryType) {
            return this.createDDLDefinitionExecution(preparedQuery.getStatement(), preparedQuery.getParameters(), stateMachine, slug, retryCount);
        }

        private <T extends Statement> DDLDefinitionExecution<T> createDDLDefinitionExecution(T statement, List<Expression> parameters, QueryStateMachine stateMachine, String slug, int retryCount) {
            DDLDefinitionTask task = (DDLDefinitionTask)this.tasks.get(statement.getClass());
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object)statement.getClass().getSimpleName());
            stateMachine.setUpdateType(task.getName());
            return new DDLDefinitionExecution(task, statement, slug, retryCount, this.transactionManager, this.metadata, this.accessControl, stateMachine, parameters, null);
        }
    }
}

