/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.ParameterUtils;
import com.facebook.presto.sql.SqlFormatterUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DDLDefinitionTask<CreateView> {
    private final JsonCodec<ViewDefinition> codec;
    private final SqlParser sqlParser;

    @Inject
    public CreateViewTask(JsonCodec<ViewDefinition> codec, SqlParser sqlParser, FeaturesConfig featuresConfig) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public String explain(CreateView statement, List<Expression> parameters) {
        return "CREATE VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        accessControl.checkCanCreateView(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), name);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser, Optional.of(parameters));
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata, accessControl, parameters, warningCollector);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ViewDefinition.ViewColumn((String)field.getName().get(), field.getType())).collect(ImmutableList.toImmutableList());
        List columnMetadata = (List)columns.stream().map(column -> new ColumnMetadata(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata viewMetadata = new ConnectorTableMetadata(MetadataUtil.toSchemaTableName(name), columnMetadata);
        Optional<String> owner = Optional.of(session.getUser());
        if (statement.getSecurity().orElse(null) == CreateView.Security.INVOKER) {
            owner = Optional.empty();
        }
        String data = this.codec.toJson((Object)new ViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, owner, !owner.isPresent()));
        metadata.createView(session, name.getCatalogName(), viewMetadata, data, statement.isReplace());
        return Futures.immediateFuture(null);
    }

    private Analysis analyzeStatement(Statement statement, Session session, Metadata metadata, AccessControl accessControl, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, ParameterUtils.parameterExtractor(statement, parameters), warningCollector);
        return analyzer.analyze(statement);
    }
}

