/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.ParameterUtils;
import com.facebook.presto.sql.SqlFormatterUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.MaterializedViewColumnMappingExtractor;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateMaterializedViewTask
implements DDLDefinitionTask<CreateMaterializedView> {
    private final SqlParser sqlParser;

    @Inject
    public CreateMaterializedViewTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "CREATE MATERIALIZED VIEW";
    }

    @Override
    public ListenableFuture<?> execute(CreateMaterializedView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        block4: {
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> viewHandle = metadata.getTableHandle(session, viewName);
            if (viewHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw new SemanticException(SemanticErrorCode.MATERIALIZED_VIEW_ALREADY_EXISTS, (Node)statement, "Materialized view '%s' already exists", new Object[]{viewName});
                }
                return Futures.immediateFuture(null);
            }
            accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), viewName);
            accessControl.checkCanCreateView(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), viewName);
            Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
            Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, warningCollector);
            Analysis analysis = analyzer.analyze((Statement)statement);
            ConnectorId connectorId = metadata.getCatalogHandle(session, viewName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + viewName.getCatalogName()));
            List columnMetadata = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ColumnMetadata((String)field.getName().get(), field.getType())).collect(ImmutableList.toImmutableList());
            Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
            Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(connectorId, viewName.getCatalogName(), sqlProperties, session, metadata, parameterLookup);
            ConnectorTableMetadata viewMetadata = new ConnectorTableMetadata(MetadataUtil.toSchemaTableName(viewName), columnMetadata, properties, statement.getComment());
            String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser, Optional.of(parameters));
            List baseTables = (List)analysis.getTableNodes().stream().map(table -> {
                QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)table, table.getName());
                if (!viewName.getCatalogName().equals(tableName.getCatalogName())) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Materialized view %s created from a base table in a different catalog %s is not supported.", new Object[]{viewName, tableName});
                }
                return MetadataUtil.toSchemaTableName(tableName);
            }).distinct().collect(ImmutableList.toImmutableList());
            MaterializedViewColumnMappingExtractor extractor = new MaterializedViewColumnMappingExtractor(analysis, session);
            ConnectorMaterializedViewDefinition viewDefinition = new ConnectorMaterializedViewDefinition(sql, viewName.getSchemaName(), viewName.getObjectName(), baseTables, Optional.of(session.getUser()), extractor.getMaterializedViewColumnMappings(), extractor.getMaterializedViewDirectColumnMappings(), extractor.getBaseTablesOnOuterJoinSide(), Optional.empty());
            try {
                metadata.createMaterializedView(session, viewName.getCatalogName(), viewMetadata, viewDefinition, statement.isNotExists());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block4;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public String explain(CreateMaterializedView statement, List<Expression> parameters) {
        return "CREATE MATERIALIZED VIEW" + statement.getName();
    }
}

