/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UnnestStatsRule
implements ComposableStatsCalculator.Rule<UnnestNode> {
    private static final int UPPER_BOUND_ROW_COUNT_FOR_ESTIMATION = 1;

    @Override
    public Pattern<UnnestNode> getPattern() {
        return Patterns.unnest();
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(UnnestNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        PlanNodeStatsEstimate.Builder calculatedStats = PlanNodeStatsEstimate.builder();
        if (sourceStats.getOutputRowCount() > 1.0) {
            return Optional.empty();
        }
        calculatedStats.setOutputRowCount(sourceStats.getOutputRowCount());
        for (VariableReferenceExpression variableReferenceExpression : node.getReplicateVariables()) {
            calculatedStats.addVariableStatistics(variableReferenceExpression, sourceStats.getVariableStatistics(variableReferenceExpression));
        }
        for (Map.Entry entry : node.getUnnestVariables().entrySet()) {
            List unnestToVariables = (List)entry.getValue();
            VariableStatsEstimate stats = sourceStats.getVariableStatistics((VariableReferenceExpression)entry.getKey());
            for (VariableReferenceExpression variable : unnestToVariables) {
                calculatedStats.addVariableStatistics(variable, VariableStatsEstimate.builder().setAverageRowSize(stats.getAverageRowSize()).build());
            }
        }
        if (node.getOrdinalityVariable().isPresent()) {
            calculatedStats.addVariableStatistics(node.getOrdinalityVariable().get(), VariableStatsEstimate.builder().setLowValue(0.0).setNullsFraction(0.0).build());
        }
        return Optional.of(calculatedStats.build());
    }
}

