/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.PlanStatisticsWithSourceInfo;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.PlanHasher;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsTracker {
    private static final Logger LOG = Logger.get(HistoryBasedPlanStatisticsTracker.class);
    private static final Set<QueryType> ALLOWED_QUERY_TYPES = ImmutableSet.of((Object)QueryType.SELECT, (Object)QueryType.INSERT);
    private final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider;
    private final SessionPropertyManager sessionPropertyManager;
    private final PlanHasher planHasher;

    public HistoryBasedPlanStatisticsTracker(Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, SessionPropertyManager sessionPropertyManager, PlanHasher planHasher) {
        this.historyBasedPlanStatisticsProvider = Objects.requireNonNull(historyBasedPlanStatisticsProvider, "historyBasedPlanStatisticsProvider is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.planHasher = Objects.requireNonNull(planHasher, "planHasher is null");
    }

    public void trackStatistics(QueryExecution queryExecution) {
        queryExecution.addFinalQueryInfoListener(this::trackStatistics);
    }

    @VisibleForTesting
    public HistoryBasedPlanStatisticsProvider getHistoryBasedPlanStatisticsProvider() {
        return this.historyBasedPlanStatisticsProvider.get();
    }

    public Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> getQueryStats(QueryInfo queryInfo) {
        if (!SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(queryInfo.getSession().toSession(this.sessionPropertyManager))) {
            return ImmutableMap.of();
        }
        if (queryInfo.getFailureInfo() != null || !queryInfo.getOutputStage().isPresent() || !queryInfo.getOutputStage().get().getPlan().isPresent()) {
            return ImmutableMap.of();
        }
        if (!queryInfo.getQueryType().isPresent() || !ALLOWED_QUERY_TYPES.contains(queryInfo.getQueryType().get())) {
            return ImmutableMap.of();
        }
        if (!queryInfo.isFinalQueryInfo()) {
            LOG.error("Expected final query info when updating history based statistics: %s", new Object[]{queryInfo});
            return ImmutableMap.of();
        }
        StageInfo outputStage = queryInfo.getOutputStage().get();
        List<StageInfo> allStages = outputStage.getAllStages();
        Map<PlanNodeId, PlanNodeStats> planNodeStatsMap = PlanNodeStatsSummarizer.aggregateStageStats(allStages);
        HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatistics = new HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo>();
        for (StageInfo stageInfo : allStages) {
            if (!stageInfo.getPlan().isPresent()) continue;
            PlanNode root = stageInfo.getPlan().get().getRoot();
            for (PlanNode planNode : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root)) {
                PlanNodeStats planNodeStats;
                if (!planNode.getStatsEquivalentPlanNode().isPresent() || (planNodeStats = planNodeStatsMap.get(planNode.getId())) == null) continue;
                PlanNode statsEquivalentPlanNode = (PlanNode)planNode.getStatsEquivalentPlanNode().get();
                for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
                    Optional<String> hash = this.planHasher.hash(statsEquivalentPlanNode, strategy);
                    if (!hash.isPresent()) continue;
                    double outputPositions = planNodeStats.getPlanNodeOutputPositions();
                    double outputBytes = planNodeStats.getPlanNodeOutputDataSize().toBytes();
                    planStatistics.putIfAbsent(new PlanNodeWithHash(statsEquivalentPlanNode, hash), new PlanStatisticsWithSourceInfo(planNode.getId(), new PlanStatistics(Estimate.of((double)outputPositions), Double.isNaN(outputBytes) ? Estimate.unknown() : Estimate.of((double)outputBytes), 1.0), (SourceInfo)new HistoryBasedSourceInfo(hash)));
                }
            }
        }
        return ImmutableMap.copyOf(planStatistics);
    }

    private void trackStatistics(QueryInfo queryInfo) {
        Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatistics = this.getQueryStats(queryInfo);
        Map historicalPlanStatistics = (Map)planStatistics.entrySet().stream().filter(entry -> ((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo() instanceof HistoryBasedSourceInfo).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new HistoricalPlanStatistics(((PlanStatisticsWithSourceInfo)entry.getValue()).getPlanStatistics())));
        if (historicalPlanStatistics.isEmpty()) {
            return;
        }
        this.historyBasedPlanStatisticsProvider.get().putStats((Map)ImmutableMap.copyOf((Map)historicalPlanStatistics));
    }
}

