/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.HistoryBasedPlanStatisticsCalculator;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsTracker;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.statistics.EmptyPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.sql.planner.CachingPlanHasher;
import com.facebook.presto.sql.planner.PlanHasher;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Objects;

public class HistoryBasedPlanStatisticsManager {
    private final SessionPropertyManager sessionPropertyManager;
    private final PlanHasher planHasher;
    private HistoryBasedPlanStatisticsProvider historyBasedPlanStatisticsProvider = EmptyPlanStatisticsProvider.getInstance();
    private boolean statisticsProviderAdded;

    @Inject
    public HistoryBasedPlanStatisticsManager(ObjectMapper objectMapper, SessionPropertyManager sessionPropertyManager) {
        Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.planHasher = new CachingPlanHasher(objectMapper);
    }

    public void addHistoryBasedPlanStatisticsProviderFactory(HistoryBasedPlanStatisticsProvider historyBasedPlanStatisticsProvider) {
        if (this.statisticsProviderAdded) {
            throw new IllegalStateException("historyBasedPlanStatisticsProvider can only be set once");
        }
        this.historyBasedPlanStatisticsProvider = historyBasedPlanStatisticsProvider;
        this.statisticsProviderAdded = true;
    }

    public HistoryBasedPlanStatisticsCalculator getHistoryBasedPlanStatisticsCalculator(StatsCalculator delegate) {
        return new HistoryBasedPlanStatisticsCalculator(() -> this.historyBasedPlanStatisticsProvider, delegate, this.planHasher);
    }

    public HistoryBasedPlanStatisticsTracker getHistoryBasedPlanStatisticsTracker() {
        return new HistoryBasedPlanStatisticsTracker(() -> this.historyBasedPlanStatisticsProvider, this.sessionPropertyManager, this.planHasher);
    }
}

