/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.PlanHasher;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Plans;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsCalculator
implements StatsCalculator {
    private final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider;
    private final StatsCalculator delegate;
    private final PlanHasher planHasher;

    public HistoryBasedPlanStatisticsCalculator(Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, StatsCalculator delegate, PlanHasher planHasher) {
        this.historyBasedPlanStatisticsProvider = Objects.requireNonNull(historyBasedPlanStatisticsProvider, "historyBasedPlanStatisticsProvider is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.planHasher = Objects.requireNonNull(planHasher, "planHasher is null");
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate delegateStats = this.delegate.calculateStats(node, sourceStats, lookup, session, types);
        return this.getStatistics(node, session, lookup, delegateStats);
    }

    @VisibleForTesting
    public PlanHasher getPlanHasher() {
        return this.planHasher;
    }

    private PlanNodeStatsEstimate getStatistics(PlanNode planNode, Session session, Lookup lookup, PlanNodeStatsEstimate delegateStats) {
        PlanNode plan = Plans.resolveGroupReferences(planNode, lookup);
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session)) {
            return delegateStats;
        }
        ImmutableMap.Builder allHashesBuilder = ImmutableMap.builder();
        for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
            Optional hash2 = plan.getStatsEquivalentPlanNode().flatMap(node -> this.planHasher.hash((PlanNode)node, strategy));
            hash2.ifPresent(string -> allHashesBuilder.put((Object)strategy, string));
        }
        ImmutableMap allHashes = allHashesBuilder.build();
        List planNodeWithHashes = (List)allHashes.values().stream().distinct().map(hash -> new PlanNodeWithHash(plan, Optional.of(hash))).collect(ImmutableList.toImmutableList());
        if (planNodeWithHashes.isEmpty()) {
            planNodeWithHashes = ImmutableList.of((Object)new PlanNodeWithHash(plan, Optional.empty()));
        }
        Map statistics = this.historyBasedPlanStatisticsProvider.get().getStats(planNodeWithHashes);
        for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
            for (Map.Entry entry : statistics.entrySet()) {
                if (!allHashes.containsKey(strategy) || !Optional.of(allHashes.get(strategy)).equals(((PlanNodeWithHash)entry.getKey()).getHash())) continue;
                return delegateStats.combineStats(((HistoricalPlanStatistics)entry.getValue()).getLastRunStatistics(), (SourceInfo)new HistoryBasedSourceInfo(((PlanNodeWithHash)entry.getKey()).getHash()));
            }
        }
        return Optional.ofNullable(statistics.get(new PlanNodeWithHash(plan, Optional.empty()))).map(HistoricalPlanStatistics::getLastRunStatistics).map(planStatistics -> delegateStats.combineStats((PlanStatistics)planStatistics, (SourceInfo)new HistoryBasedSourceInfo(Optional.empty()))).orElse(delegateStats);
    }
}

