/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataBasedSystemTablesProvider
implements SystemTablesProvider {
    private final Metadata metadata;
    private final String catalogName;

    public MetadataBasedSystemTablesProvider(Metadata metadata, String catalogName) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    @Override
    public Set<SystemTable> listSystemTables(ConnectorSession session) {
        return ImmutableSet.of();
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Optional<SystemTable> systemTable = this.metadata.getSystemTable(((FullConnectorSession)session).getSession(), new QualifiedObjectName(this.catalogName, tableName.getSchemaName(), tableName.getTableName()));
        if (systemTable.isPresent() && systemTable.get().getDistribution() != SystemTable.Distribution.SINGLE_COORDINATOR) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Distribution for dynamic system table must be " + SystemTable.Distribution.SINGLE_COORDINATOR);
        }
        return systemTable;
    }
}

