/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class DistinctTypeCasts {
    public static final DistinctTypeToCast DISTINCT_TYPE_TO_CAST = new DistinctTypeToCast();
    public static final DistinctTypeFromCast DISTINCT_TYPE_FROM_CAST = new DistinctTypeFromCast();

    private DistinctTypeCasts() {
    }

    private static void checkCanCast(Type fromType, Type toType) {
        DistinctType toDistinctType;
        if (fromType instanceof DistinctType && toType instanceof DistinctType) {
            DistinctType fromDistinctType = (DistinctType)fromType;
            DistinctType toDistinctType2 = (DistinctType)toType;
            if (!DistinctType.hasAncestorRelationship((DistinctType)fromDistinctType, (DistinctType)toDistinctType2)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast %s to %s", fromDistinctType.getName(), toDistinctType2.getName()));
            }
        } else if (fromType instanceof DistinctType) {
            DistinctType fromDistinctType = (DistinctType)fromType;
            if (!fromDistinctType.getBaseType().equals(toType)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast %s to %s", fromDistinctType.getName(), toType));
            }
        } else if (toType instanceof DistinctType && !(toDistinctType = (DistinctType)toType).getBaseType().equals(fromType)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast %s to %s", fromType, toDistinctType.getName()));
        }
    }

    public static class DistinctTypeFromCast
    extends SqlOperator {
        private DistinctTypeFromCast() {
            super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T2"), (Object)Signature.withVariadicBound((String)"T1", (String)"DistinctType")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T2"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T1")));
        }

        @Override
        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            Type fromType = boundVariables.getTypeVariable("T1");
            Type toType = boundVariables.getTypeVariable("T2");
            DistinctTypeCasts.checkCanCast(fromType, toType);
            return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), MethodHandles.identity(fromType.getJavaType()));
        }
    }

    public static class DistinctTypeToCast
    extends SqlOperator {
        private DistinctTypeToCast() {
            super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.withVariadicBound((String)"T2", (String)"DistinctType")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T2"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T1")));
        }

        @Override
        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            Type fromType = boundVariables.getTypeVariable("T1");
            Type toType = boundVariables.getTypeVariable("T2");
            DistinctTypeCasts.checkCanCast(fromType, toType);
            return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), MethodHandles.identity(fromType.getJavaType()));
        }
    }
}

