/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing;

import com.facebook.presto.tracing.SimpleTracerPoint;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleTracerBlock {
    private final List<SimpleTracerPoint> points = new CopyOnWriteArrayList<SimpleTracerPoint>();
    private final long startTime = System.nanoTime();
    private long endTime;

    public SimpleTracerBlock(String annotation) {
        this.addPoint(new SimpleTracerPoint(annotation));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void end(String annotation) {
        this.endTime = System.nanoTime();
        if (this.startTime > this.endTime) {
            throw new RuntimeException("Block start time " + this.startTime + " is greater than end time " + this.endTime);
        }
        this.addPoint(new SimpleTracerPoint(annotation));
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void addPoint(SimpleTracerPoint point) {
        this.points.add(point);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start time", this.startTime).add("end time", this.endTime).add("points", this.points).toString();
    }
}

