/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.analyzer.MaterializedViewCandidateExtractor;
import com.facebook.presto.sql.analyzer.MaterializedViewQueryOptimizer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Table;
import java.util.Set;

public class MaterializedViewOptimizationRewriteUtils {
    private static final Logger log = Logger.get(MaterializedViewOptimizationRewriteUtils.class);

    private MaterializedViewOptimizationRewriteUtils() {
    }

    public static Query optimizeQueryUsingMaterializedView(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, Query node) {
        MaterializedViewCandidateExtractor materializedViewCandidateExtractor = new MaterializedViewCandidateExtractor(session, metadata);
        materializedViewCandidateExtractor.process((Node)node);
        Set<QualifiedObjectName> materializedViewCandidates = materializedViewCandidateExtractor.getMaterializedViewCandidates();
        for (QualifiedObjectName candidate : materializedViewCandidates) {
            Query optimizedQuery = MaterializedViewOptimizationRewriteUtils.getQueryWithMaterializedViewOptimization(metadata, session, sqlParser, accessControl, node, candidate);
            if (node == optimizedQuery) continue;
            if (SystemSessionProperties.isMaterializedViewDataConsistencyEnabled(session)) {
                MaterializedViewStatus materializedViewStatus = metadata.getMaterializedViewStatus(session, candidate);
                if (materializedViewStatus.isFullyMaterialized() || materializedViewStatus.isPartiallyMaterialized()) {
                    session.getRuntimeStats().addMetricValue("optimizedWithMaterializedViewCount", RuntimeUnit.NONE, 1L);
                    return optimizedQuery;
                }
                session.getRuntimeStats().addMetricValue("manyPartitionsMissingInMaterializedViewCount", RuntimeUnit.NONE, 1L);
                continue;
            }
            session.getRuntimeStats().addMetricValue("optimizedWithMaterializedViewCount", RuntimeUnit.NONE, 1L);
            return optimizedQuery;
        }
        return node;
    }

    private static Query getQueryWithMaterializedViewOptimization(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, Query statement, QualifiedObjectName materializedViewQualifiedObjectName) {
        try {
            ConnectorMaterializedViewDefinition materializedView = metadata.getMaterializedView(session, materializedViewQualifiedObjectName).get();
            Table materializedViewTable = new Table(QualifiedName.of((String)materializedView.getTable()));
            Query materializedViewDefinition = (Query)sqlParser.createStatement(materializedView.getOriginalSql(), ParsingUtil.createParsingOptions(session));
            return (Query)new MaterializedViewQueryOptimizer(metadata, session, sqlParser, accessControl, new RowExpressionDomainTranslator(metadata), materializedViewTable, materializedViewDefinition).rewrite((Node)statement);
        }
        catch (RuntimeException ex) {
            log.warn("Failed to get materialized view for %s, with exception: %s", new Object[]{materializedViewQualifiedObjectName, ex.getMessage()});
            return statement;
        }
    }
}

