/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class ExplainRewrite
implements StatementRewrite.Rewrite {
    ExplainRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameter, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, parser, queryExplainer, warningCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final QueryPreparer queryPreparer;
        private final Optional<QueryExplainer> queryExplainer;
        private final WarningCollector warningCollector;

        public Visitor(Session session, SqlParser parser, Optional<QueryExplainer> queryExplainer, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.queryPreparer = new QueryPreparer(Objects.requireNonNull(parser, "queryPreparer is null"));
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitExplain(Explain node, Void context) throws SemanticException {
            if (node.isAnalyze()) {
                Statement statement = (Statement)this.process((Node)node.getStatement(), context);
                return new Explain(statement, node.isAnalyze(), node.isVerbose(), node.getOptions());
            }
            ExplainType.Type planType = ExplainType.Type.LOGICAL;
            ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
            List options = node.getOptions();
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainType)) continue;
                planType = ((ExplainType)option).getType();
                if (planType != ExplainType.Type.IO) break;
                planFormat = ExplainFormat.Type.JSON;
                break;
            }
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainFormat)) continue;
                planFormat = ((ExplainFormat)option).getType();
                break;
            }
            return this.getQueryPlan(node, planType, planFormat);
        }

        private Node getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
            String plan;
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(this.session, node.getStatement(), this.warningCollector);
            if (planType == ExplainType.Type.VALIDATE) {
                this.queryExplainer.get().analyze(this.session, preparedQuery.getStatement(), preparedQuery.getParameters(), this.warningCollector);
                return QueryUtil.singleValueQuery((String)"Valid", (boolean)true);
            }
            switch (planFormat) {
                case GRAPHVIZ: {
                    plan = this.queryExplainer.get().getGraphvizPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                    break;
                }
                case JSON: {
                    plan = this.queryExplainer.get().getJsonPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                    break;
                }
                case TEXT: {
                    plan = this.queryExplainer.get().getPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), node.isVerbose(), this.warningCollector);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Explain Format: " + planFormat.toString());
                }
            }
            return QueryUtil.singleValueQuery((String)"Query Plan", (String)plan);
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

