/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TopNRowNumberNode
extends InternalPlanNode {
    private final PlanNode source;
    private final WindowNode.Specification specification;
    private final VariableReferenceExpression rowNumberVariable;
    private final int maxRowCountPerPartition;
    private final boolean partial;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public TopNRowNumberNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") WindowNode.Specification specification, @JsonProperty(value="rowNumberVariable") VariableReferenceExpression rowNumberVariable, @JsonProperty(value="maxRowCountPerPartition") int maxRowCountPerPartition, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        super(sourceLocation, id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Preconditions.checkArgument((boolean)specification.getOrderingScheme().isPresent(), (Object)"specification orderingScheme is absent");
        Objects.requireNonNull(rowNumberVariable, "rowNumberVariable is null");
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        Objects.requireNonNull(hashVariable, "hashVariable is null");
        this.source = source;
        this.specification = specification;
        this.rowNumberVariable = rowNumberVariable;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.partial = partial;
        this.hashVariable = hashVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        ImmutableList.Builder builder = ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables());
        if (!this.partial) {
            builder.add((Object)this.rowNumberVariable);
        }
        return builder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WindowNode.Specification getSpecification() {
        return this.specification;
    }

    public List<VariableReferenceExpression> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public OrderingScheme getOrderingScheme() {
        return this.specification.getOrderingScheme().get();
    }

    @JsonProperty
    public VariableReferenceExpression getRowNumberVariable() {
        return this.rowNumberVariable;
    }

    @JsonProperty
    public int getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopNRowNumber(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TopNRowNumberNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.rowNumberVariable, this.maxRowCountPerPartition, this.partial, this.hashVariable);
    }
}

