/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SortNode
extends InternalPlanNode {
    private final PlanNode source;
    private final OrderingScheme orderingScheme;
    private final boolean isPartial;

    @JsonCreator
    public SortNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="orderingScheme") OrderingScheme orderingScheme, @JsonProperty(value="isPartial") boolean isPartial) {
        super(sourceLocation, id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.source = source;
        this.orderingScheme = orderingScheme;
        this.isPartial = isPartial;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getSortProperties((PlanNode)this);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @JsonProperty(value="orderingScheme")
    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty(value="isPartial")
    public boolean isPartial() {
        return this.isPartial;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SortNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme, this.isPartial);
    }
}

