/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AssignUniqueId
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression idVariable;

    @JsonCreator
    public AssignUniqueId(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="idVariable") VariableReferenceExpression idVariable) {
        super(sourceLocation, id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.idVariable = Objects.requireNonNull(idVariable, "idVariable is null");
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables()).add((Object)this.idVariable).build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public VariableReferenceExpression getIdVariable() {
        return this.idVariable;
    }

    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getAssignUniqueIdProperties((PlanNode)this);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitAssignUniqueId(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
        return new AssignUniqueId(newChildren.get(0).getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.idVariable);
    }
}

