/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;

public class HashBasedPartialDistinctLimit
implements PlanOptimizer {
    private final FunctionAndTypeManager functionAndTypeManager;

    public HashBasedPartialDistinctLimit(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = functionAndTypeManager;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (SystemSessionProperties.isHashBasedDistinctLimitEnabled(session)) {
            return SimplePlanRewriter.rewriteWith(new Rewriter(session, idAllocator, variableAllocator, this.functionAndTypeManager), plan, null);
        }
        return plan;
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Session session;
        private final PlanNodeIdAllocator idAllocator;
        private final PlanVariableAllocator variableAllocator;
        private final FunctionAndTypeManager functionAndTypeManager;

        private Rewriter(Session session, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager) {
            this.session = session;
            this.idAllocator = idAllocator;
            this.variableAllocator = variableAllocator;
            this.functionAndTypeManager = functionAndTypeManager;
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.isPartial() && node.getLimit() <= (long)SystemSessionProperties.getHashBasedDistinctLimitThreshold(this.session)) {
                VariableReferenceExpression hashVariable;
                if (node.getHashVariable().isPresent()) {
                    hashVariable = (VariableReferenceExpression)node.getHashVariable().get();
                } else if (node.getDistinctVariables().size() == 1 && ((VariableReferenceExpression)node.getDistinctVariables().get(0)).getType() == BigintType.BIGINT) {
                    hashVariable = (VariableReferenceExpression)node.getDistinctVariables().get(0);
                } else {
                    return node;
                }
                return new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getSource(), (RowExpression)Expressions.call(this.functionAndTypeManager, "k_distinct", (Type)BigintType.BIGINT, new RowExpression[]{hashVariable, Expressions.constant(node.getLimit(), (Type)BigintType.BIGINT)}));
            }
            return context.defaultRewrite((PlanNode)node);
        }
    }
}

