/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoveRedundantAggregateDistinct
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(RemoveRedundantAggregateDistinct::aggregateDistinctOfUniqueKey);

    private static boolean aggregateDistinctOfUniqueKey(AggregationNode node) {
        return !node.getAggregations().isEmpty() && ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && node.getAggregations().values().stream().filter(AggregationNode.Aggregation::isDistinct).anyMatch(a -> ((GroupReference)node.getSource()).getLogicalProperties().get().isDistinct(Stream.concat(node.getGroupingKeys().stream().map(VariableReferenceExpression.class::cast), a.getArguments().stream().map(VariableReferenceExpression.class::cast)).collect(Collectors.toSet())));
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getSource(), node.getAggregations().entrySet().stream().collect(Collectors.toMap(e -> (VariableReferenceExpression)e.getKey(), e -> {
            AggregationNode.Aggregation aggregation;
            if (((AggregationNode.Aggregation)e.getValue()).isDistinct()) {
                if (((GroupReference)node.getSource()).getLogicalProperties().get().isDistinct(Stream.concat(node.getGroupingKeys().stream().map(VariableReferenceExpression.class::cast), ((AggregationNode.Aggregation)e.getValue()).getArguments().stream().map(VariableReferenceExpression.class::cast)).collect(Collectors.toSet()))) {
                    aggregation = AggregationNode.Aggregation.removeDistinct((AggregationNode.Aggregation)((AggregationNode.Aggregation)e.getValue()));
                    return aggregation;
                }
            }
            aggregation = (AggregationNode.Aggregation)e.getValue();
            return aggregation;
        })), node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable()));
    }
}

