/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.List;

public class PushLimitThroughOuterJoin
implements Rule<LimitNode> {
    private static final Capture<JoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.join().with(Patterns.Join.type().matching(type -> type == JoinNode.Type.LEFT || type == JoinNode.Type.RIGHT)).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isPushLimitThroughOuterJoin(context.getSession())) {
            return Rule.Result.empty();
        }
        JoinNode joinNode = (JoinNode)((Object)captures.get(CHILD));
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        if (joinNode.getType() == JoinNode.Type.LEFT && !PushLimitThroughOuterJoin.isLimited(left, context.getLookup(), parent.getCount())) {
            left = new LimitNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), left, parent.getCount(), LimitNode.Step.PARTIAL);
        }
        if (joinNode.getType() == JoinNode.Type.RIGHT && !PushLimitThroughOuterJoin.isLimited(right, context.getLookup(), parent.getCount())) {
            right = new LimitNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), right, parent.getCount(), LimitNode.Step.PARTIAL);
        }
        if (joinNode.getLeft() != left || joinNode.getRight() != right) {
            return Rule.Result.ofPlanNode(parent.replaceChildren((List)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left, (Object)right)))));
        }
        return Rule.Result.empty();
    }

    private static boolean isLimited(PlanNode node, Lookup lookup, long limit) {
        Range<Long> cardinality = QueryCardinalityUtil.extractCardinality(node, lookup);
        return cardinality.hasUpperBound() && (Long)cardinality.upperEndpoint() <= limit;
    }
}

