/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.google.common.base.MoreObjects;
import java.util.Optional;

public class MaxCardProperty {
    private Optional<Long> value;

    public MaxCardProperty() {
        this.value = Optional.empty();
    }

    public MaxCardProperty(Long value) {
        this.value = Optional.of(value);
    }

    public boolean moreGeneral(MaxCardProperty otherMaxCardProperty) {
        return !this.value.isPresent() && !otherMaxCardProperty.value.isPresent() || this.value.isPresent() && (!otherMaxCardProperty.value.isPresent() || otherMaxCardProperty.value.get() >= this.value.get());
    }

    public void update(long value) {
        if (!this.value.isPresent() || this.value.get().compareTo(value) > 0) {
            this.value = Optional.of(value);
        }
    }

    public void update(MaxCardProperty sourceMaxCardProperty) {
        if (sourceMaxCardProperty.value.isPresent()) {
            this.value = this.value.isPresent() ? Optional.of(Long.min(this.value.get(), sourceMaxCardProperty.value.get())) : Optional.of(sourceMaxCardProperty.value.get());
        }
    }

    public boolean isAtMostOne() {
        return this.isAtMost(1L);
    }

    public boolean isAtMost(long n) {
        if (this.value.isPresent()) {
            return this.value.get() <= n;
        }
        return false;
    }

    public void multiply(MaxCardProperty maxCardProperty) {
        if (!maxCardProperty.value.isPresent()) {
            this.value = Optional.empty();
            return;
        }
        if (this.value.isPresent()) {
            this.value = Optional.of(this.value.get() * maxCardProperty.value.get());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value.isPresent() ? this.value.get() : "null").toString();
    }
}

