/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.KeyProperty;
import com.facebook.presto.sql.planner.iterative.properties.MaxCardProperty;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalPropertiesImpl
implements LogicalProperties {
    private final MaxCardProperty maxCardProperty;
    private final KeyProperty keyProperty;
    private final EquivalenceClassProperty equivalenceClassProperty;

    public LogicalPropertiesImpl(EquivalenceClassProperty equivalenceClassProperty, MaxCardProperty maxCardProperty, KeyProperty keyProperty) {
        this.equivalenceClassProperty = Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
        this.maxCardProperty = Objects.requireNonNull(maxCardProperty, "maxCardProperty is null");
        this.keyProperty = Objects.requireNonNull(keyProperty, "keyProperty is null");
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private boolean isMoreGeneralThan(LogicalPropertiesImpl otherLogicalProperties) {
        Objects.requireNonNull(otherLogicalProperties, "otherLogicalProperties is null");
        return this.maxCardProperty.moreGeneral(otherLogicalProperties.maxCardProperty) && this.keyProperty.moreGeneral(otherLogicalProperties.keyProperty) && this.equivalenceClassProperty.isMoreGeneralThan(otherLogicalProperties.equivalenceClassProperty);
    }

    public boolean equals(LogicalPropertiesImpl otherLogicalProperties) {
        Objects.requireNonNull(otherLogicalProperties, "otherLogicalProperties is null");
        return this.isMoreGeneralThan(otherLogicalProperties) && otherLogicalProperties.isMoreGeneralThan(this);
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments(Assignments assignments) {
        Objects.requireNonNull(assignments, "assignments is null");
        HashMap<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry e : assignments.entrySet()) {
            if (!(e.getValue() instanceof VariableReferenceExpression)) continue;
            inverseVariableAssignments.put((VariableReferenceExpression)e.getValue(), (VariableReferenceExpression)e.getKey());
        }
        return inverseVariableAssignments;
    }

    private static void normalizeKeyPropertyAndSetMaxCard(KeyProperty keyProperty, MaxCardProperty maxCardProperty, EquivalenceClassProperty equivalenceClassProperty) {
        if (maxCardProperty.isAtMostOne()) {
            keyProperty.empty();
            return;
        }
        Optional<KeyProperty> normalizedKeyProperty = keyProperty.normalize(equivalenceClassProperty);
        keyProperty.empty();
        if (normalizedKeyProperty.isPresent()) {
            keyProperty.addKeys(normalizedKeyProperty.get());
        } else {
            maxCardProperty.update(1L);
        }
    }

    public boolean isDistinct(Set<VariableReferenceExpression> keyVars) {
        Objects.requireNonNull(keyVars, "keyVars is null");
        LogicalPropertiesImpl.checkArgument(!keyVars.isEmpty(), "keyVars is empty");
        return this.keyRequirementSatisfied(new Key(keyVars));
    }

    public boolean isAtMostSingleRow() {
        return this.isAtMost(1L);
    }

    public boolean isAtMost(long n) {
        return this.maxCardProperty.isAtMost(n);
    }

    private boolean keyRequirementSatisfied(Key keyRequirement) {
        Objects.requireNonNull(keyRequirement, "keyRequirement is null");
        if (this.maxCardProperty.isAtMostOne()) {
            return true;
        }
        Optional<Key> normalizedKeyRequirement = keyRequirement.normalize(this.equivalenceClassProperty);
        if (normalizedKeyRequirement.isPresent()) {
            return this.keyProperty.satisfiesKeyRequirement(keyRequirement);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("KeyProperty", (Object)this.keyProperty).add("EquivalenceClassProperty", (Object)this.equivalenceClassProperty).add("MaxCardProperty", (Object)this.maxCardProperty).toString();
    }

    public static class InverseVariableMappingsWithEquivalence {
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings;

        InverseVariableMappingsWithEquivalence(EquivalenceClassProperty equivalenceClassProperty, Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings) {
            Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
            Objects.requireNonNull(inverseMappings, "inverseMappings is null");
            this.equivalenceClassProperty = equivalenceClassProperty;
            this.inverseMappings = inverseMappings;
        }

        private boolean containsKey(VariableReferenceExpression variable) {
            if (!this.inverseMappings.containsKey(variable)) {
                RowExpression head = this.equivalenceClassProperty.getEquivalenceClassHead((RowExpression)variable);
                ArrayList<RowExpression> equivalentVariables = new ArrayList<RowExpression>();
                equivalentVariables.add(head);
                equivalentVariables.addAll(this.equivalenceClassProperty.getEquivalenceClasses(head));
                for (RowExpression e : equivalentVariables) {
                    if (!(e instanceof VariableReferenceExpression) || !this.inverseMappings.containsKey(e)) continue;
                    this.inverseMappings.put(variable, this.inverseMappings.get(e));
                    break;
                }
            }
            return this.inverseMappings.containsKey(variable);
        }

        public Optional<VariableReferenceExpression> get(VariableReferenceExpression variable) {
            Objects.requireNonNull(variable, "variable is null");
            if (this.containsKey(variable)) {
                return Optional.of(this.inverseMappings.get(variable));
            }
            return Optional.empty();
        }
    }

    public static class JoinBuilder {
        private final LogicalPropertiesImpl leftProperties;
        private final LogicalPropertiesImpl rightProperties;
        private final List<JoinNode.EquiJoinClause> equijoinPredicates;
        private final JoinNode.Type joinType;
        private final Optional<RowExpression> filterPredicate;
        private final List<VariableReferenceExpression> outputVariables;
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final FunctionResolution functionResolution;
        private KeyProperty keyProperty = new KeyProperty();

        JoinBuilder(LogicalPropertiesImpl leftProperties, LogicalPropertiesImpl rightProperties, List<JoinNode.EquiJoinClause> equijoinPredicates, JoinNode.Type joinType, Optional<RowExpression> filterPredicate, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
            Objects.requireNonNull(leftProperties, "leftProperties is null");
            Objects.requireNonNull(rightProperties, "rightProperties is null");
            Objects.requireNonNull(equijoinPredicates, "equijoinPredicates is null");
            Objects.requireNonNull(joinType, "joinType is null");
            Objects.requireNonNull(filterPredicate, "filterPredicate is null");
            Objects.requireNonNull(outputVariables, "outputVariables is null");
            this.leftProperties = leftProperties;
            this.rightProperties = rightProperties;
            this.equijoinPredicates = equijoinPredicates;
            this.joinType = joinType;
            this.filterPredicate = filterPredicate;
            this.outputVariables = outputVariables;
            this.functionResolution = functionResolution;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            boolean nToOne = false;
            boolean oneToN = false;
            Set<VariableReferenceExpression> rightJoinVariables = this.equijoinPredicates.stream().map(predicate -> predicate.getRight()).collect(Collectors.toSet());
            Set<VariableReferenceExpression> leftJoinVariables = this.equijoinPredicates.stream().map(predicate -> predicate.getLeft()).collect(Collectors.toSet());
            if ((this.rightProperties.maxCardProperty.isAtMostOne() || !rightJoinVariables.isEmpty() && this.rightProperties.isDistinct(rightJoinVariables)) && (this.joinType == JoinNode.Type.INNER || this.joinType == JoinNode.Type.LEFT || this.joinType == JoinNode.Type.FULL && this.leftProperties.maxCardProperty.isAtMost(1L))) {
                nToOne = true;
                this.keyProperty.addKeys(this.leftProperties.keyProperty);
                this.maxCardProperty.update(this.leftProperties.maxCardProperty);
            }
            if ((this.leftProperties.maxCardProperty.isAtMostOne() || !leftJoinVariables.isEmpty() && this.leftProperties.isDistinct(leftJoinVariables)) && (this.joinType == JoinNode.Type.INNER || this.joinType == JoinNode.Type.RIGHT || this.joinType == JoinNode.Type.FULL && this.rightProperties.maxCardProperty.isAtMost(1L))) {
                oneToN = true;
                this.keyProperty.addKeys(this.rightProperties.keyProperty);
                this.maxCardProperty.update(this.rightProperties.maxCardProperty);
            }
            if (!nToOne && !oneToN) {
                this.maxCardProperty.update(this.leftProperties.maxCardProperty);
                this.maxCardProperty.multiply(this.rightProperties.maxCardProperty);
                if (this.joinType == JoinNode.Type.INNER) {
                    this.keyProperty.addKeys(this.leftProperties.keyProperty);
                    this.keyProperty = this.keyProperty.concat(this.rightProperties.keyProperty);
                }
            }
            if (this.joinType == JoinNode.Type.INNER || this.joinType == JoinNode.Type.LEFT) {
                this.equivalenceClassProperty.update(this.leftProperties.equivalenceClassProperty);
            }
            if (this.joinType == JoinNode.Type.INNER || this.joinType == JoinNode.Type.RIGHT) {
                this.equivalenceClassProperty.update(this.rightProperties.equivalenceClassProperty);
            }
            if (this.joinType == JoinNode.Type.INNER) {
                this.equijoinPredicates.stream().forEach(joinVariables -> this.equivalenceClassProperty.update((RowExpression)joinVariables.getLeft(), (RowExpression)joinVariables.getRight()));
                if (this.filterPredicate.isPresent()) {
                    this.equivalenceClassProperty.update(this.filterPredicate.get());
                }
            }
            LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(this.keyProperty, this.maxCardProperty, this.equivalenceClassProperty);
            ProjectBuilder projectBuilder = new ProjectBuilder(new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty), AssignmentUtils.identityAssignments(this.outputVariables), this.functionResolution);
            return projectBuilder.build();
        }
    }

    public static class DistinctLimitBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final Set<VariableReferenceExpression> keyVariables;
        private final long limit;
        private final List<VariableReferenceExpression> outputVariables;
        private final FunctionResolution functionResolution;

        DistinctLimitBuilder(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables, Long limit, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            Objects.requireNonNull(keyVariables, "keyVariables is null");
            Objects.requireNonNull(outputVariables, "outputVariables is null");
            Objects.requireNonNull(limit, "limit is null");
            LogicalPropertiesImpl.checkArgument(!keyVariables.isEmpty(), "keyVariables is empty");
            this.sourceProperties = sourceProperties;
            this.keyVariables = keyVariables;
            this.outputVariables = outputVariables;
            this.limit = limit;
            this.functionResolution = functionResolution;
        }

        LogicalPropertiesImpl build() {
            AggregationBuilder aggregationBuilder = new AggregationBuilder(this.sourceProperties, this.keyVariables, this.outputVariables, this.functionResolution);
            PropagateAndLimitBuilder propagateAndLimitBuilder = new PropagateAndLimitBuilder(aggregationBuilder.build(), this.limit, this.functionResolution);
            return propagateAndLimitBuilder.build();
        }
    }

    public static class AggregationBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final Key key;
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final List<VariableReferenceExpression> outputVariables;
        private final KeyProperty keyProperty = new KeyProperty();
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private final FunctionResolution functionResolution;

        AggregationBuilder(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            Objects.requireNonNull(keyVariables, "keyVariables is null");
            Objects.requireNonNull(outputVariables, "outputVariables is null");
            LogicalPropertiesImpl.checkArgument(!keyVariables.isEmpty(), "keyVariables is empty");
            this.sourceProperties = sourceProperties;
            this.key = new Key(keyVariables);
            this.outputVariables = outputVariables;
            this.functionResolution = functionResolution;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.sourceProperties.keyProperty);
            this.maxCardProperty.update(this.sourceProperties.maxCardProperty);
            this.equivalenceClassProperty.update(this.sourceProperties.equivalenceClassProperty);
            if (!this.maxCardProperty.isAtMostOne()) {
                this.keyProperty.addKey(this.key);
                LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(this.keyProperty, this.maxCardProperty, this.equivalenceClassProperty);
            }
            ProjectBuilder projectBuilder = new ProjectBuilder(new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty), AssignmentUtils.identityAssignments(this.outputVariables), this.functionResolution);
            return projectBuilder.build();
        }
    }

    public static class PropagateAndLimitBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final long limit;
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final KeyProperty keyProperty = new KeyProperty();

        PropagateAndLimitBuilder(LogicalPropertiesImpl sourceProperties, long limit, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            this.sourceProperties = sourceProperties;
            this.limit = limit;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.sourceProperties.keyProperty);
            this.maxCardProperty.update(this.sourceProperties.maxCardProperty);
            this.maxCardProperty.update(this.limit);
            this.equivalenceClassProperty.update(this.sourceProperties.equivalenceClassProperty);
            if (this.maxCardProperty.isAtMostOne()) {
                this.keyProperty.empty();
            }
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }

    public static class ProjectBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final Assignments assignments;
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private KeyProperty keyProperty = new KeyProperty();
        private EquivalenceClassProperty equivalenceClassProperty;

        ProjectBuilder(LogicalPropertiesImpl sourceProperties, Assignments assignments, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            Objects.requireNonNull(assignments, "assignments is null");
            this.sourceProperties = sourceProperties;
            this.assignments = assignments;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.sourceProperties.keyProperty);
            this.maxCardProperty.update(this.sourceProperties.maxCardProperty);
            this.equivalenceClassProperty.update(this.sourceProperties.equivalenceClassProperty);
            Map inverseVariableAssignments = LogicalPropertiesImpl.inverseVariableAssignments(this.assignments);
            this.keyProperty = this.keyProperty.project(new InverseVariableMappingsWithEquivalence(this.equivalenceClassProperty, inverseVariableAssignments));
            this.equivalenceClassProperty = this.equivalenceClassProperty.project(inverseVariableAssignments);
            LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(this.keyProperty, this.maxCardProperty, this.equivalenceClassProperty);
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }

    public static class FilterBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final RowExpression predicate;
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final KeyProperty keyProperty = new KeyProperty();

        FilterBuilder(LogicalPropertiesImpl sourceProperties, RowExpression predicate, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            Objects.requireNonNull(predicate, "predicate is null");
            this.sourceProperties = sourceProperties;
            this.predicate = predicate;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.sourceProperties.keyProperty);
            this.maxCardProperty.update(this.sourceProperties.maxCardProperty);
            this.equivalenceClassProperty.update(this.sourceProperties.equivalenceClassProperty);
            if (this.equivalenceClassProperty.update(this.predicate)) {
                LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(this.keyProperty, this.maxCardProperty, this.equivalenceClassProperty);
            }
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }

    public static class TableScanBuilder {
        List<Set<VariableReferenceExpression>> keys;
        KeyProperty keyProperty = new KeyProperty();
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty;

        TableScanBuilder(List<Set<VariableReferenceExpression>> keys, FunctionResolution functionResolution) {
            Objects.requireNonNull(keys, "keys is null");
            this.keys = keys;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.keys.stream().map(keyCols -> new Key((Set<VariableReferenceExpression>)keyCols)).collect(Collectors.toSet()));
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }

    public static class PropagateBuilder {
        private final LogicalPropertiesImpl sourceProperties;
        private final KeyProperty keyProperty = new KeyProperty();
        private final MaxCardProperty maxCardProperty = new MaxCardProperty();
        private final EquivalenceClassProperty equivalenceClassProperty;

        PropagateBuilder(LogicalPropertiesImpl sourceProperties, FunctionResolution functionResolution) {
            Objects.requireNonNull(sourceProperties, "sourceProperties is null");
            this.sourceProperties = sourceProperties;
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            this.keyProperty.addKeys(this.sourceProperties.keyProperty);
            this.maxCardProperty.update(this.sourceProperties.maxCardProperty);
            this.equivalenceClassProperty.update(this.sourceProperties.equivalenceClassProperty);
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }

    public static class NoPropagateBuilder {
        KeyProperty keyProperty = new KeyProperty();
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty;

        NoPropagateBuilder(FunctionResolution functionResolution) {
            this.equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        }

        LogicalPropertiesImpl build() {
            return new LogicalPropertiesImpl(this.equivalenceClassProperty, this.maxCardProperty, this.keyProperty);
        }
    }
}

