/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class KeyProperty {
    private final Set<Key> keys;

    public KeyProperty() {
        this.keys = new HashSet<Key>();
    }

    public KeyProperty(Set<Key> keys) {
        this.keys = keys;
    }

    public boolean moreGeneral(KeyProperty otherKeyProperty) {
        Objects.requireNonNull(otherKeyProperty, "otherKeyProperty is null");
        return this.keys.isEmpty() && otherKeyProperty.keys.isEmpty() || otherKeyProperty.keys.stream().allMatch(k -> this.satisfiesKeyRequirement((Key)k));
    }

    public boolean satisfiesKeyRequirement(Key keyRequirement) {
        Objects.requireNonNull(keyRequirement, "keyRequirement is null");
        return this.keys.stream().anyMatch(k -> k.keySatisifiesRequirement(keyRequirement));
    }

    public void addKeys(Set<Key> keys) {
        Objects.requireNonNull(keys, "keys is null");
        keys.stream().forEach(k -> this.addKey((Key)k));
    }

    public void addKeys(KeyProperty keyProperty) {
        Objects.requireNonNull(keyProperty, "keyProperty is null");
        this.addKeys(keyProperty.keys);
    }

    public void addKey(Key key) {
        Objects.requireNonNull(key, "key is null");
        this.addNonRedundantKey(key);
    }

    private void addNonRedundantKey(Key newKey) {
        Objects.requireNonNull(newKey, "newKey is null");
        HashSet<Key> removedKeys = new HashSet<Key>();
        for (Key key : this.keys) {
            if (key.keySatisifiesRequirement(newKey)) {
                return;
            }
            if (!newKey.keySatisifiesRequirement(key)) continue;
            removedKeys.add(key);
        }
        this.keys.add(newKey);
        this.keys.removeAll(removedKeys);
    }

    public Optional<KeyProperty> normalize(EquivalenceClassProperty equivalenceClassProperty) {
        Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
        KeyProperty result = new KeyProperty();
        for (Key key : this.keys) {
            Optional<Key> normalizedKey = key.normalize(equivalenceClassProperty);
            if (!normalizedKey.isPresent()) {
                return Optional.empty();
            }
            result.addKey(normalizedKey.get());
        }
        return Optional.of(result);
    }

    public KeyProperty project(LogicalPropertiesImpl.InverseVariableMappingsWithEquivalence inverseVariableMappings) {
        Objects.requireNonNull(inverseVariableMappings, "inverseVariableMappings is null");
        KeyProperty result = new KeyProperty();
        this.keys.stream().forEach(key -> {
            Optional<Key> projectedKey = key.project(inverseVariableMappings);
            if (projectedKey.isPresent()) {
                result.addKey(projectedKey.get());
            }
        });
        return result;
    }

    public void empty() {
        this.keys.clear();
    }

    public KeyProperty concat(KeyProperty toConcatKeyProp) {
        Objects.requireNonNull(toConcatKeyProp, "toConcatKeyProp is null");
        KeyProperty result = new KeyProperty();
        for (Key thisKey : this.keys) {
            for (Key toConcatKey : toConcatKeyProp.keys) {
                result.addKey(thisKey.concat(toConcatKey));
            }
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keys", (Object)String.join((CharSequence)",", this.keys.stream().map(Key::toString).collect(Collectors.toList()))).toString();
    }
}

