/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Key {
    private final Set<VariableReferenceExpression> variables;

    public Key(Set<VariableReferenceExpression> variables) {
        Objects.requireNonNull(variables, "Variables is null.");
        Preconditions.checkArgument((!variables.isEmpty() ? 1 : 0) != 0, (Object)"Variables is empty");
        this.variables = variables;
    }

    public boolean keySatisifiesRequirement(Key keyRequirement) {
        Objects.requireNonNull(keyRequirement, "Key requirement must be provided.");
        return this.variables.stream().allMatch(vk -> keyRequirement.variables.stream().anyMatch(vr -> vk.equals(vr)));
    }

    public Optional<Key> normalize(EquivalenceClassProperty equivalenceClassProperty) {
        Objects.requireNonNull(equivalenceClassProperty, "Equivalence class property must be provided.");
        HashSet<VariableReferenceExpression> unBoundVariables = new HashSet<VariableReferenceExpression>();
        this.variables.stream().forEach(v -> {
            RowExpression eqHead = equivalenceClassProperty.getEquivalenceClassHead((RowExpression)v);
            if (!(eqHead instanceof ConstantExpression)) {
                unBoundVariables.add((VariableReferenceExpression)eqHead);
            }
        });
        if (unBoundVariables.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Key(unBoundVariables));
    }

    public Optional<Key> project(LogicalPropertiesImpl.InverseVariableMappingsWithEquivalence inverseVariableMappings) {
        Objects.requireNonNull(inverseVariableMappings, "Inverse variable mappings must be provided.");
        HashSet<VariableReferenceExpression> mappedVariables = new HashSet<VariableReferenceExpression>();
        for (VariableReferenceExpression v : this.variables) {
            Optional<VariableReferenceExpression> mappedVariable = inverseVariableMappings.get(v);
            if (mappedVariable.isPresent()) {
                mappedVariables.add(mappedVariable.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Key(mappedVariables));
    }

    public Key concat(Key toConcatKey) {
        Objects.requireNonNull(toConcatKey, "Key must be provided.");
        HashSet<VariableReferenceExpression> concatenatedVariables = new HashSet<VariableReferenceExpression>();
        concatenatedVariables.addAll(this.variables);
        concatenatedVariables.addAll(toConcatKey.variables);
        return new Key(concatenatedVariables);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variables", (Object)String.join((CharSequence)",", this.variables.stream().map(VariableReferenceExpression::toString).collect(Collectors.toList()))).toString();
    }
}

