/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Match;
import com.facebook.presto.matching.Matcher;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.iterative.PlanNodeMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleIndex;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class IterativeOptimizer
implements PlanOptimizer {
    private final RuleStatsRecorder stats;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final List<PlanOptimizer> legacyRules;
    private final RuleIndex ruleIndex;
    private final Optional<LogicalPropertiesProvider> logicalPropertiesProvider;

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Set<Rule<?>> rules) {
        this(stats, statsCalculator, costCalculator, (List<PlanOptimizer>)ImmutableList.of(), Optional.empty(), rules);
    }

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Optional<LogicalPropertiesProvider> logicalPropertiesProvider, Set<Rule<?>> rules) {
        this(stats, statsCalculator, costCalculator, (List<PlanOptimizer>)ImmutableList.of(), logicalPropertiesProvider, rules);
    }

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, List<PlanOptimizer> legacyRules, Set<Rule<?>> newRules) {
        this(stats, statsCalculator, costCalculator, legacyRules, Optional.empty(), newRules);
    }

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, List<PlanOptimizer> legacyRules, Optional<LogicalPropertiesProvider> logicalPropertiesProvider, Set<Rule<?>> newRules) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.ruleIndex = RuleIndex.builder().register(newRules).build();
        this.logicalPropertiesProvider = Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider is null");
        stats.registerAll(newRules);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (!SystemSessionProperties.isNewOptimizerEnabled(session) && !this.legacyRules.isEmpty()) {
            for (PlanOptimizer optimizer : this.legacyRules) {
                plan = optimizer.optimize(plan, session, variableAllocator.getTypes(), variableAllocator, idAllocator, warningCollector);
            }
            return plan;
        }
        Memo memo = SystemSessionProperties.isExploitConstraints(session) ? new Memo(idAllocator, plan, this.logicalPropertiesProvider) : new Memo(idAllocator, plan, Optional.empty());
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve((GroupReference)((Object)planNode))));
        PlanNodeMatcher matcher = new PlanNodeMatcher(lookup);
        Duration timeout = SystemSessionProperties.getOptimizerTimeout(session);
        Context context = new Context(memo, lookup, idAllocator, variableAllocator, System.nanoTime(), timeout.toMillis(), session, warningCollector);
        boolean planChanged = this.exploreGroup(memo.getRootGroup(), context, (Matcher)matcher);
        if (!planChanged) {
            return plan;
        }
        return memo.extract();
    }

    private boolean exploreGroup(int group, Context context, Matcher matcher) {
        boolean progress = this.exploreNode(group, context, matcher);
        while (this.exploreChildren(group, context, matcher)) {
            progress = true;
            if (this.exploreNode(group, context, matcher)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context, Matcher matcher) {
        PlanNode node = context.memo.getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            context.checkTimeoutNotExhausted();
            done = true;
            Iterator possiblyMatchingRules = this.ruleIndex.getCandidates(node).iterator();
            while (possiblyMatchingRules.hasNext()) {
                Rule.Result result;
                Rule rule = (Rule)possiblyMatchingRules.next();
                if (!rule.isEnabled(context.session) || !(result = this.transform(node, rule, matcher, context)).getTransformedPlan().isPresent()) continue;
                node = context.memo.replace(group, result.getTransformedPlan().get(), rule.getClass().getName());
                done = false;
                progress = true;
            }
        }
        return progress;
    }

    private <T> Rule.Result transform(PlanNode node, Rule<T> rule, Matcher matcher, Context context) {
        long duration;
        Rule.Result result;
        Match match = matcher.match(rule.getPattern(), (Object)node);
        if (match.isEmpty()) {
            return Rule.Result.empty();
        }
        try {
            long start = System.nanoTime();
            result = rule.apply(match.value(), match.captures(), this.ruleContext(context));
            duration = System.nanoTime() - start;
        }
        catch (RuntimeException e) {
            this.stats.recordFailure(rule);
            throw e;
        }
        this.stats.record(rule, duration, !result.isEmpty());
        if (SystemSessionProperties.isVerboseRuntimeStatsEnabled(context.session)) {
            context.session.getRuntimeStats().addMetricValue(String.format("rule%sTimeNanos", rule.getClass().getSimpleName()), RuntimeUnit.NANO, duration);
        }
        return result;
    }

    private boolean exploreChildren(int group, Context context, Matcher matcher) {
        boolean progress = false;
        PlanNode expression = context.memo.getNode(group);
        for (PlanNode child : expression.getSources()) {
            Preconditions.checkState((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context, matcher)) continue;
            progress = true;
        }
        return progress;
    }

    private Rule.Context ruleContext(final Context context) {
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, Optional.of(context.memo), context.lookup, context.session, context.variableAllocator.getTypes());
        final CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.of(context.memo), context.session);
        return new Rule.Context(){

            @Override
            public Lookup getLookup() {
                return context.lookup;
            }

            @Override
            public PlanNodeIdAllocator getIdAllocator() {
                return context.idAllocator;
            }

            @Override
            public PlanVariableAllocator getVariableAllocator() {
                return context.variableAllocator;
            }

            @Override
            public Session getSession() {
                return context.session;
            }

            @Override
            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            @Override
            public CostProvider getCostProvider() {
                return costProvider;
            }

            @Override
            public void checkTimeoutNotExhausted() {
                context.checkTimeoutNotExhausted();
            }

            @Override
            public WarningCollector getWarningCollector() {
                return context.warningCollector;
            }
        };
    }

    private static class Context {
        private final Memo memo;
        private final Lookup lookup;
        private final PlanNodeIdAllocator idAllocator;
        private final PlanVariableAllocator variableAllocator;
        private final long startTimeInNanos;
        private final long timeoutInMilliseconds;
        private final Session session;
        private final WarningCollector warningCollector;

        public Context(Memo memo, Lookup lookup, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, long startTimeInNanos, long timeoutInMilliseconds, Session session, WarningCollector warningCollector) {
            Preconditions.checkArgument((timeoutInMilliseconds >= 0L ? 1 : 0) != 0, (Object)"Timeout has to be a non-negative number [milliseconds]");
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.variableAllocator = variableAllocator;
            this.startTimeInNanos = startTimeInNanos;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.session = session;
            this.warningCollector = warningCollector;
        }

        public void checkTimeoutNotExhausted() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeInNanos) >= this.timeoutInMilliseconds) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.OPTIMIZER_TIMEOUT, String.format("The optimizer exhausted the time limit of %d ms", this.timeoutInMilliseconds));
            }
        }
    }
}

