/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariableResolver;
import com.facebook.presto.type.LikeFunctions;
import com.google.common.base.Preconditions;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import java.util.Map;
import java.util.Objects;

public class Interpreters {
    private Interpreters() {
    }

    static Object interpretDereference(Object value, Type returnType, int index) {
        Block row = (Block)value;
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field index: %s", (int)index);
        if (row.isNull(index)) {
            return null;
        }
        Class javaType = returnType.getJavaType();
        if (javaType == Long.TYPE) {
            return returnType.getLong(row, index);
        }
        if (javaType == Double.TYPE) {
            return returnType.getDouble(row, index);
        }
        if (javaType == Boolean.TYPE) {
            return returnType.getBoolean(row, index);
        }
        if (javaType == Slice.class) {
            return returnType.getSlice(row, index);
        }
        if (!javaType.isPrimitive()) {
            return returnType.getObject(row, index);
        }
        throw new UnsupportedOperationException("Dereference a unsupported primitive type: " + javaType.getName());
    }

    static boolean interpretLikePredicate(Type valueType, Slice value, Regex regex) {
        if (valueType instanceof VarcharType) {
            return LikeFunctions.likeVarchar(value, regex);
        }
        Preconditions.checkState((boolean)(valueType instanceof CharType), (Object)"LIKE value is neither VARCHAR or CHAR");
        return LikeFunctions.likeChar(Long.valueOf(((CharType)valueType).getLength()), value, regex);
    }

    public static class LambdaVariableResolver
    implements VariableResolver {
        private final Map<String, Object> values;

        public LambdaVariableResolver(Map<String, Object> values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @Override
        public Object getValue(VariableReferenceExpression variable) {
            Preconditions.checkState((boolean)this.values.containsKey(variable.getName()), (String)"values does not contain %s", (Object)variable);
            return this.values.get(variable.getName());
        }
    }
}

