/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.SingleRowBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.scalar.ArraySubscriptOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.ConstantExpressionVerifier;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.VarArgsToMapAdapterGenerator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Coercer;
import com.facebook.presto.sql.planner.DesugarAtTimeZoneRewriter;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.Interpreters;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariableResolver;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import com.facebook.presto.sql.planner.iterative.rule.DesugarCurrentUser;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.FastutilSetHelper;
import com.facebook.presto.util.LegacyRowFieldOrdinalAccessUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
public class ExpressionInterpreter {
    private static final long MAX_SERIALIZABLE_OBJECT_SIZE = 1000L;
    private final Expression expression;
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;
    private final Session session;
    private final ConnectorSession connectorSession;
    private final boolean optimize;
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final InterpretedFunctionInvoker functionInvoker;
    private final boolean legacyRowFieldOrdinalAccess;
    private final Visitor visitor;
    private final IdentityHashMap<LikePredicate, Regex> likePatternCache = new IdentityHashMap();
    private final IdentityHashMap<InListExpression, Set<?>> inListCache = new IdentityHashMap();

    public static ExpressionInterpreter expressionInterpreter(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, false);
    }

    public static ExpressionInterpreter expressionOptimizer(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, true);
    }

    public static Object evaluateConstantExpression(Expression expression, Type expectedType, Metadata metadata, Session session, Map<NodeRef<Parameter>, Expression> parameters) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(expression, Scope.create());
        Type actualType = analyzer.getExpressionTypes().get(NodeRef.of((Node)expression));
        if (!metadata.getFunctionAndTypeManager().canCoerce(actualType, expectedType)) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, String.format("Cannot cast type %s to %s", actualType.getTypeSignature(), expectedType.getTypeSignature()), new Object[0]);
        }
        ImmutableMap coercions = ImmutableMap.builder().putAll(analyzer.getExpressionCoercions()).put((Object)NodeRef.of((Node)expression), (Object)expectedType).build();
        return ExpressionInterpreter.evaluateConstantExpression(expression, (Map<NodeRef<Expression>, Type>)coercions, analyzer.getTypeOnlyCoercions(), metadata, session, (Set<NodeRef<Expression>>)ImmutableSet.of(), parameters);
    }

    private static Object evaluateConstantExpression(Expression expression, Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions, Metadata metadata, Session session, Set<NodeRef<Expression>> columnReferences, Map<NodeRef<Parameter>, Expression> parameters) {
        Objects.requireNonNull(columnReferences, "columnReferences is null");
        ConstantExpressionVerifier.verifyExpressionIsConstant(columnReferences, expression);
        Expression rewrite = Coercer.addCoercions(expression, coercions, typeOnlyCoercions);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(rewrite, Scope.create());
        rewrite = DesugarAtTimeZoneRewriter.rewrite(rewrite, analyzer.getExpressionTypes());
        Expression canonicalized = CanonicalizeExpressionRewriter.canonicalizeExpression(rewrite);
        analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(canonicalized, Scope.create());
        Object result = ExpressionInterpreter.expressionInterpreter(canonicalized, metadata, session, analyzer.getExpressionTypes()).evaluate();
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    private ExpressionInterpreter(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes, boolean optimize) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        this.session = Objects.requireNonNull(session, "session is null");
        this.connectorSession = session.toConnectorSession();
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        Verify.verify((boolean)expressionTypes.containsKey(NodeRef.of((Node)expression)));
        this.optimize = optimize;
        this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionAndTypeManager());
        this.legacyRowFieldOrdinalAccess = SystemSessionProperties.isLegacyRowFieldOrdinalAccessEnabled(session);
        this.visitor = new Visitor();
    }

    public Type getType() {
        return this.expressionTypes.get(NodeRef.of((Node)this.expression));
    }

    public Object evaluate() {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate() not allowed for optimizer");
        return this.visitor.process((Node)this.expression, null);
    }

    public Object evaluate(VariableResolver inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(SymbolResolver) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public Object optimize(VariableResolver inputs) {
        Preconditions.checkState((boolean)this.optimize, (Object)"evaluate(SymbolResolver) not allowed for interpreter");
        return this.visitor.process((Node)this.expression, inputs);
    }

    private Expression createFailureFunction(RuntimeException exception, Type type) {
        Objects.requireNonNull(exception, "Exception is null");
        String failureInfo = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure(exception).toFailureInfo());
        if (exception instanceof PrestoException) {
            long errorCode = ((PrestoException)((Object)exception)).getErrorCode().getCode();
            FunctionCall jsonParse = new FunctionCall(QualifiedName.of((String)"json_parse"), (List)ImmutableList.of((Object)new StringLiteral(failureInfo)));
            FunctionCall failureFunction = new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)this.literalEncoder.toExpression(errorCode, (Type)IntegerType.INTEGER), (Object)jsonParse));
            return new Cast((Expression)failureFunction, type.getTypeSignature().toString());
        }
        FunctionCall jsonParse = new FunctionCall(QualifiedName.of((String)"json_parse"), (List)ImmutableList.of((Object)new StringLiteral(failureInfo)));
        FunctionCall failureFunction = new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)jsonParse));
        return new Cast((Expression)failureFunction, type.getTypeSignature().toString());
    }

    private static boolean isArray(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private final Map<NodeRef<Expression>, Type> generatedExpressionTypes = new HashMap<NodeRef<Expression>, Type>();

        private Visitor() {
        }

        public Object visitFieldReference(FieldReference node, Object context) {
            throw new UnsupportedOperationException("Field references not supported in interpreter");
        }

        protected Object visitDereferenceExpression(DereferenceExpression node, Object context) {
            OptionalInt rowIndex;
            Type type = this.type(node.getBase());
            if (type == null) {
                return node;
            }
            Type returnType = this.type((Expression)node);
            if (TypeUtils.isEnumType((Type)type) && TypeUtils.isEnumType((Type)returnType)) {
                return ExpressionTreeUtils.resolveEnumLiteral(node, returnType);
            }
            Object base = this.process((Node)node.getBase(), context);
            if (base == null) {
                return null;
            }
            if (this.hasUnresolvedValue(base)) {
                return new DereferenceExpression(this.toExpression(base, type), node.getField());
            }
            RowType rowType = (RowType)type;
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            if (ExpressionInterpreter.this.legacyRowFieldOrdinalAccess && index < 0 && (rowIndex = LegacyRowFieldOrdinalAccessUtil.parseAnonymousRowFieldOrdinalAccess(fieldName, fields)).isPresent()) {
                index = rowIndex.getAsInt();
            }
            return Interpreters.interpretDereference(base, returnType, index);
        }

        protected Object visitIdentifier(Identifier node, Object context) {
            return ((VariableResolver)context).getValue(Expressions.variable(ExpressionTreeUtils.getSourceLocation((Node)node), node.getValue(), this.type((Expression)node)));
        }

        protected Object visitParameter(Parameter node, Object context) {
            return node;
        }

        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((VariableResolver)context).getValue(Expressions.variable(ExpressionTreeUtils.getSourceLocation((Node)node), node.getName(), this.type((Expression)node)));
        }

        protected Object visitLiteral(Literal node, Object context) {
            return LiteralInterpreter.evaluate(ExpressionInterpreter.this.metadata, ExpressionInterpreter.this.connectorSession, (Expression)node);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object defaultResult = this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                Object result = this.processWithExceptionHandling(whenClause.getResult(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(result, this.type(whenClause.getResult()))));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                defaultResult = result;
                break;
            }
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression resultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SearchedCaseExpression(whenClauses, Optional.ofNullable(resultExpression));
        }

        protected Object visitIfExpression(IfExpression node, Object context) {
            Object trueValue = this.processWithExceptionHandling(node.getTrueValue(), context);
            Object falseValue = this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
            Object condition = this.processWithExceptionHandling(node.getCondition(), context);
            if (condition instanceof Expression) {
                Expression falseValueExpression = falseValue == null ? null : this.toExpression(falseValue, this.type((Expression)node.getFalseValue().get()));
                return new IfExpression(this.toExpression(condition, this.type(node.getCondition())), this.toExpression(trueValue, this.type(node.getTrueValue())), falseValueExpression);
            }
            if (Boolean.TRUE.equals(condition)) {
                return trueValue;
            }
            return falseValue;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process((Node)expression, context);
            }
            catch (RuntimeException e) {
                return ExpressionInterpreter.this.createFailureFunction(e, this.type(expression));
            }
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = this.type(node.getOperand());
            Expression defaultClause = node.getDefaultValue().orElse(null);
            Object defaultResult = this.processWithExceptionHandling(defaultClause, context);
            if (operand == null) {
                return defaultResult;
            }
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                Object result = this.processWithExceptionHandling(whenClause.getResult(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(result, this.type(whenClause.getResult()))));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, this.type(whenClause.getOperand()))) continue;
                defaultResult = result;
                break;
            }
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SimpleCaseExpression(this.toExpression(operand, this.type(node.getOperand())), whenClauses, Optional.ofNullable(defaultExpression));
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2)));
        }

        private void addGeneratedExpressionType(Expression expression, Type type) {
            this.generatedExpressionTypes.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        }

        private Type type(Expression expression) {
            Type type = this.generatedExpressionTypes.get(NodeRef.of((Node)expression));
            if (type != null) {
                return type;
            }
            return (Type)ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)expression));
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            ImmutableList expressions;
            Type type = this.type((Expression)node);
            List values = node.getOperands().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).filter(Objects::nonNull).flatMap(expression -> {
                if (expression instanceof CoalesceExpression) {
                    return ((CoalesceExpression)expression).getOperands().stream();
                }
                return Stream.of(expression);
            }).collect(Collectors.toList());
            if (!values.isEmpty() && !(values.get(0) instanceof Expression) || values.size() == 1) {
                return values.get(0);
            }
            ImmutableList.Builder operandsBuilder = ImmutableList.builder();
            HashSet<Expression> visitedExpression = new HashSet<Expression>();
            for (Object value2 : values) {
                Expression expression2 = this.toExpression(value2, type);
                if (!ExpressionDeterminismEvaluator.isDeterministic(expression2) || visitedExpression.add(expression2)) {
                    operandsBuilder.add((Object)expression2);
                }
                if (!(expression2 instanceof Literal) || expression2 instanceof NullLiteral) continue;
                break;
            }
            if ((expressions = operandsBuilder.build()).isEmpty()) {
                return null;
            }
            if (expressions.size() == 1) {
                return Iterables.getOnlyElement((Iterable)expressions);
            }
            return new CoalesceExpression((List)expressions);
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            Expression valueListExpression = node.getValueList();
            if (!(valueListExpression instanceof InListExpression)) {
                if (!ExpressionInterpreter.this.optimize) {
                    throw new UnsupportedOperationException("IN predicate value list type not yet implemented: " + valueListExpression.getClass().getName());
                }
                return node;
            }
            InListExpression valueList = (InListExpression)valueListExpression;
            Verify.verify((!valueList.getValues().isEmpty() ? 1 : 0) != 0);
            if (value == null) {
                return null;
            }
            Set<?> set = (Set<?>)ExpressionInterpreter.this.inListCache.get(valueList);
            if (!ExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                if (valueList.getValues().stream().allMatch(Literal.class::isInstance)) {
                    if (valueList.getValues().stream().noneMatch(NullLiteral.class::isInstance)) {
                        Set objectSet = valueList.getValues().stream().map(expression -> this.process((Node)expression, context)).collect(Collectors.toSet());
                        set = FastutilSetHelper.toFastutilHashSet(objectSet, this.type(node.getValue()), ExpressionInterpreter.this.metadata.getFunctionAndTypeManager());
                    }
                }
                ExpressionInterpreter.this.inListCache.put(valueList, set);
            }
            if (set != null && !(value instanceof Expression)) {
                return set.contains(value);
            }
            boolean hasUnresolvedValue = false;
            if (value instanceof Expression) {
                hasUnresolvedValue = true;
            }
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Type> types = new ArrayList<Type>(valueList.getValues().size());
            for (Expression expression2 : valueList.getValues()) {
                Object inValue = this.process((Node)expression2, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(this.type(expression2));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                Boolean result = (Boolean)this.invokeOperator(OperatorType.EQUAL, this.types(node.getValue(), expression2), (List<Object>)ImmutableList.of((Object)value, (Object)inValue));
                if (result == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !result.booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = this.type(node.getValue());
                List<Expression> expressionValues = this.toExpressions(values, types);
                List simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter(ExpressionDeterminismEvaluator::isDeterministic).distinct(), expressionValues.stream().filter(expression -> !ExpressionDeterminismEvaluator.isDeterministic(expression))).collect(ImmutableList.toImmutableList());
                return new InPredicate(this.toExpression(value, type), (Expression)new InListExpression(simplifiedExpressionValues));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitExists(ExistsPredicate node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("Exists subquery not yet implemented");
            }
            return node;
        }

        protected Object visitSubqueryExpression(SubqueryExpression node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("Subquery not yet implemented");
            }
            return node;
        }

        protected Object visitArithmeticUnary(ArithmeticUnaryExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new ArithmeticUnaryExpression(node.getSign(), this.toExpression(value, this.type(node.getValue())));
            }
            switch (node.getSign()) {
                case PLUS: {
                    return value;
                }
                case MINUS: {
                    FunctionHandle operatorHandle = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.NEGATION, TypeSignatureProvider.fromTypes(this.types(node.getValue())));
                    MethodHandle handle = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getJavaScalarFunctionImplementation(operatorHandle).getMethodHandle();
                    if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == SqlFunctionProperties.class) {
                        handle = handle.bindTo(ExpressionInterpreter.this.connectorSession.getSqlFunctionProperties());
                    }
                    try {
                        return handle.invokeWithArguments(value);
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                        Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                        throw new RuntimeException(throwable.getMessage(), throwable);
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)node.getOperator().name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Operator operator = node.getOperator();
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null && operator != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                if (left == null && right == null) {
                    return false;
                }
                if (left == null && !this.hasUnresolvedValue(right)) {
                    return true;
                }
                if (right == null && !this.hasUnresolvedValue(left)) {
                    return true;
                }
            } else if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ComparisonExpression(operator, this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)operator.name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.process((Node)node.getMin(), context);
            if (min == null) {
                return null;
            }
            Object max = this.process((Node)node.getMax(), context);
            if (max == null) {
                return null;
            }
            if (this.hasUnresolvedValue(value, min, max)) {
                return new BetweenPredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(min, this.type(node.getMin())), this.toExpression(max, this.type(node.getMax())));
            }
            return this.invokeOperator(OperatorType.BETWEEN, this.types(node.getValue(), node.getMin(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)min, (Object)max));
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.process((Node)node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.process((Node)node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = this.type(node.getFirst());
            Type secondType = this.type(node.getSecond());
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(this.toExpression(first, firstType), this.toExpression(second, secondType));
            }
            FunctionAndTypeManager functionAndTypeManager = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager();
            Type commonType = functionAndTypeManager.getCommonSuperType(firstType, secondType).get();
            FunctionHandle firstCast = functionAndTypeManager.lookupCast(CastType.CAST, firstType, commonType);
            FunctionHandle secondCast = functionAndTypeManager.lookupCast(CastType.CAST, secondType, commonType);
            boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.this.functionInvoker.invoke(firstCast, ExpressionInterpreter.this.session.getSqlFunctionProperties(), (List<Object>)ImmutableList.of((Object)first)), (Object)ExpressionInterpreter.this.functionInvoker.invoke(secondCast, ExpressionInterpreter.this.session.getSqlFunctionProperties(), (List<Object>)ImmutableList.of((Object)second)))));
            if (equal) {
                return null;
            }
            return first;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(this.toExpression(value, this.type(node.getValue())));
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            Object right;
            Object left = this.process((Node)node.getLeft(), context);
            switch (node.getOperator()) {
                case AND: {
                    if (Boolean.FALSE.equals(left)) {
                        return false;
                    }
                    right = this.process((Node)node.getRight(), context);
                    if (Boolean.FALSE.equals(left) || Boolean.TRUE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.FALSE.equals(right) && !Boolean.TRUE.equals(left)) break;
                    return right;
                }
                case OR: {
                    if (Boolean.TRUE.equals(left)) {
                        return true;
                    }
                    right = this.process((Node)node.getRight(), context);
                    if (Boolean.TRUE.equals(left) || Boolean.FALSE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.TRUE.equals(right) && !Boolean.FALSE.equals(left)) break;
                    return right;
                }
                default: {
                    throw new IllegalStateException("Unknown LogicalBinaryExpression#Type");
                }
            }
            if (left == null && right == null) {
                return null;
            }
            return new LogicalBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            Object result;
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Object value = this.process((Node)expression, context);
                Type type = this.type(expression);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            FunctionHandle functionHandle = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().resolveFunction(Optional.of(ExpressionInterpreter.this.session.getSessionFunctions()), ExpressionInterpreter.this.session.getTransactionId(), FunctionAndTypeManager.qualifyObjectName(node.getName()), TypeSignatureProvider.fromTypes(argumentTypes));
            FunctionMetadata functionMetadata = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getFunctionMetadata(functionHandle);
            if (!functionMetadata.isCalledOnNullInput()) {
                for (int i = 0; i < argumentValues.size(); ++i) {
                    Object value = argumentValues.get(i);
                    if (value != null) continue;
                    return null;
                }
            }
            if (ExpressionInterpreter.this.optimize && (!functionMetadata.isDeterministic() || this.hasUnresolvedValue(argumentValues) || node.getName().equals((Object)QualifiedName.of((String)"$internal$dynamic_filter_function")) || node.getName().equals((Object)QualifiedName.of((String)"fail")))) {
                return new FunctionCall(node.getName(), node.getWindow(), node.isDistinct(), node.isIgnoreNulls(), this.toExpressions(argumentValues, argumentTypes));
            }
            FunctionImplementationType implementationType = functionMetadata.getImplementationType();
            if (implementationType.isExternal()) {
                return new FunctionCall(node.getName(), node.getWindow(), node.isDistinct(), node.isIgnoreNulls(), this.toExpressions(argumentValues, argumentTypes));
            }
            if (implementationType.equals((Object)FunctionImplementationType.JAVA)) {
                result = ExpressionInterpreter.this.functionInvoker.invoke(functionHandle, ExpressionInterpreter.this.session.getSqlFunctionProperties(), argumentValues);
            } else {
                Preconditions.checkState((boolean)implementationType.equals((Object)FunctionImplementationType.SQL));
                Expression function = SqlFunctionUtils.getSqlFunctionExpression(functionMetadata, (SqlInvokedScalarFunctionImplementation)ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getScalarFunctionImplementation(functionHandle), ExpressionInterpreter.this.metadata, new PlanVariableAllocator(), ExpressionInterpreter.this.session.getSqlFunctionProperties(), node.getArguments());
                ExpressionInterpreter functionInterpreter = new ExpressionInterpreter(function, ExpressionInterpreter.this.metadata, ExpressionInterpreter.this.session, ExpressionAnalyzer.getExpressionTypes(ExpressionInterpreter.this.session, ExpressionInterpreter.this.metadata, new SqlParser(), TypeProvider.empty(), function, Collections.emptyMap(), WarningCollector.NOOP), ExpressionInterpreter.this.optimize);
                result = functionInterpreter.visitor.process((Node)function, context);
                if (result instanceof FunctionCall) {
                    return new FunctionCall(node.getName(), node.getWindow(), node.isDistinct(), node.isIgnoreNulls(), this.toExpressions(argumentValues, argumentTypes));
                }
            }
            if (ExpressionInterpreter.this.optimize && !this.isSerializable(result, this.type((Expression)node))) {
                return new FunctionCall(node.getName(), node.getWindow(), node.isDistinct(), node.isIgnoreNulls(), this.toExpressions(argumentValues, argumentTypes));
            }
            return result;
        }

        protected Object visitLambdaExpression(LambdaExpression node, Object context) {
            if (ExpressionInterpreter.this.optimize) {
                return node;
            }
            Expression body = node.getBody();
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            FunctionType functionType = (FunctionType)ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)node));
            Preconditions.checkArgument((argumentNames.size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), argumentNames, map -> this.process((Node)body, new Interpreters.LambdaVariableResolver((Map<String, Object>)map)));
        }

        protected Object visitBindExpression(BindExpression node, Object context) {
            List<Object> values = node.getValues().stream().map(value -> this.process((Node)value, context)).collect(Collectors.toList());
            Object function = this.process((Node)node.getFunction(), context);
            if (this.hasUnresolvedValue(values) || this.hasUnresolvedValue(function)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    builder.add((Object)this.toExpression(values.get(i), this.type((Expression)node.getValues().get(i))));
                }
                return new BindExpression((List)builder.build(), this.toExpression(function, this.type(node.getFunction())));
            }
            return MethodHandles.insertArguments((MethodHandle)function, 0, values.toArray());
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Slice && node.getPattern() instanceof StringLiteral && (!node.getEscape().isPresent() || node.getEscape().get() instanceof StringLiteral)) {
                return Interpreters.interpretLikePredicate(this.type(node.getValue()), (Slice)value, this.getConstantPattern(node));
            }
            Object pattern = this.process((Node)node.getPattern(), context);
            if (pattern == null) {
                return null;
            }
            Object escape = null;
            if (node.getEscape().isPresent() && (escape = this.process((Node)node.getEscape().get(), context)) == null) {
                return null;
            }
            if (value instanceof Slice && pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                Regex regex = escape == null ? LikeFunctions.likePattern((Slice)pattern) : LikeFunctions.likePattern((Slice)pattern, (Slice)escape);
                return Interpreters.interpretLikePredicate(this.type(node.getValue()), (Slice)value, regex);
            }
            if (pattern instanceof Slice && (escape == null || escape instanceof Slice) && !LikeFunctions.isLikePattern((Slice)pattern, (Slice)escape)) {
                Slice unescapedPattern = LikeFunctions.unescapeLiteralLikePattern((Slice)pattern, (Slice)escape);
                Type valueType = this.type(node.getValue());
                VarcharType patternType = VarcharType.createVarcharType((int)unescapedPattern.length());
                FunctionAndTypeManager functionAndTypeManager = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager();
                Optional<Type> commonSuperType = functionAndTypeManager.getCommonSuperType(valueType, (Type)patternType);
                Preconditions.checkArgument((boolean)commonSuperType.isPresent(), (String)"Missing super type when optimizing %s", (Object)node);
                Expression valueExpression = this.toExpression(value, valueType);
                Expression patternExpression = this.toExpression(unescapedPattern, (Type)patternType);
                Type superType = commonSuperType.get();
                if (!valueType.equals(superType)) {
                    valueExpression = new Cast(valueExpression, superType.getTypeSignature().toString(), false, functionAndTypeManager.isTypeOnlyCoercion(valueType, superType));
                }
                if (!patternType.equals(superType)) {
                    patternExpression = new Cast(patternExpression, superType.getTypeSignature().toString(), false, functionAndTypeManager.isTypeOnlyCoercion((Type)patternType, superType));
                }
                return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, valueExpression, patternExpression);
            }
            Optional<Object> optimizedEscape = Optional.empty();
            if (node.getEscape().isPresent()) {
                optimizedEscape = Optional.of(this.toExpression(escape, this.type((Expression)node.getEscape().get())));
            }
            return new LikePredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(pattern, this.type(node.getPattern())), optimizedEscape);
        }

        private Regex getConstantPattern(LikePredicate node) {
            Regex result = (Regex)ExpressionInterpreter.this.likePatternCache.get(node);
            if (result == null) {
                StringLiteral pattern = (StringLiteral)node.getPattern();
                if (node.getEscape().isPresent()) {
                    Slice escape = ((StringLiteral)node.getEscape().get()).getSlice();
                    result = LikeFunctions.likePattern(pattern.getSlice(), escape);
                } else {
                    result = LikeFunctions.likePattern(pattern.getSlice());
                }
                ExpressionInterpreter.this.likePatternCache.put(node, result);
            }
            return result;
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.process((Node)node.getExpression(), context);
            Type targetType = ExpressionInterpreter.this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (targetType == null) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            if (value == null) {
                return null;
            }
            Type sourceType = this.type(node.getExpression());
            if (value instanceof Expression) {
                if (targetType.equals(sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe(), node.isTypeOnly());
            }
            if (node.isTypeOnly()) {
                return value;
            }
            if (ExpressionInterpreter.this.optimize && !LiteralEncoder.isSupportedLiteralType(this.type((Expression)node))) {
                return new Cast(this.toExpression(value, sourceType), node.getType(), node.isSafe(), node.isTypeOnly());
            }
            FunctionHandle operator = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, sourceType, targetType);
            try {
                Object castedValue = ExpressionInterpreter.this.functionInvoker.invoke(operator, ExpressionInterpreter.this.session.getSqlFunctionProperties(), (List<Object>)ImmutableList.of((Object)value));
                if (ExpressionInterpreter.this.optimize && !this.isSerializable(castedValue, this.type((Expression)node))) {
                    return new Cast(this.toExpression(value, sourceType), node.getType(), node.isSafe(), node.isTypeOnly());
                }
                return castedValue;
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        protected Object visitArrayConstructor(ArrayConstructor node, Object context) {
            Type elementType = ((ArrayType)this.type((Expression)node)).getElementType();
            BlockBuilder arrayBlockBuilder = elementType.createBlockBuilder(null, node.getValues().size());
            for (Expression expression : node.getValues()) {
                Object value = this.process((Node)expression, context);
                if (value instanceof Expression) {
                    FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)"array_constructor"), node.getValues());
                    this.addGeneratedExpressionType((Expression)functionCall, this.type((Expression)node));
                    return this.visitFunctionCall(functionCall, context);
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)arrayBlockBuilder, (Object)value);
            }
            return arrayBlockBuilder.build();
        }

        protected Object visitCurrentUser(CurrentUser node, Object context) {
            FunctionCall functionCall = DesugarCurrentUser.getCall(node);
            this.addGeneratedExpressionType((Expression)functionCall, this.type((Expression)node));
            return this.visitFunctionCall(functionCall, context);
        }

        protected Object visitRow(Row node, Object context) {
            RowType rowType = (RowType)this.type((Expression)node);
            List parameterTypes = rowType.getTypeParameters();
            List arguments = node.getItems();
            int cardinality = arguments.size();
            ArrayList<Object> values = new ArrayList<Object>(cardinality);
            for (Expression argument : arguments) {
                values.add(this.process((Node)argument, context));
            }
            if (this.hasUnresolvedValue(values)) {
                return new Row(this.toExpressions(values, parameterTypes));
            }
            RowBlockBuilder blockBuilder = new RowBlockBuilder(parameterTypes, null, 1);
            BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
            for (int i = 0; i < cardinality; ++i) {
                TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)singleRowBlockWriter, values.get(i));
            }
            blockBuilder.closeEntry();
            return rowType.getObject((Block)blockBuilder, 0);
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.process((Node)node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.process((Node)node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (index instanceof Long && ExpressionInterpreter.isArray(this.type(node.getBase()))) {
                ArraySubscriptOperator.checkArrayIndex((Long)index);
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(this.toExpression(base, this.type(node.getBase())), this.toExpression(index, this.type(node.getIndex())));
            }
            if (base instanceof SingleRowBlock) {
                SingleRowBlock row = (SingleRowBlock)base;
                int position = Math.toIntExact((Long)index - 1L);
                if (position < 0 || position >= row.getPositionCount()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "ROW index out of bounds: " + (position + 1));
                }
                Type returnType = (Type)this.type(node.getBase()).getTypeParameters().get(position);
                return TypeUtils.readNativeValue((Type)returnType, (Block)row, (int)position);
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        protected Object visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("QuantifiedComparison not yet implemented");
            }
            return node;
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        protected Object visitNode(Node node, Object context) {
            throw new UnsupportedOperationException("Evaluator visitor can only handle Expression nodes");
        }

        private List<Type> types(Expression ... types) {
            return (List)Stream.of(types).map(NodeRef::of).map(ExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            ArrayList<Object> valuesList = new ArrayList<Object>(values.length);
            for (Object value : values) {
                if (value == null) continue;
                valuesList.add(value);
            }
            return !valuesList.isEmpty() && this.hasUnresolvedValue(valuesList);
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(arg_0 -> ((Predicate)Predicates.instanceOf(Expression.class)).apply(arg_0));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            FunctionHandle operatorHandle = ExpressionInterpreter.this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes(argumentTypes));
            return ExpressionInterpreter.this.functionInvoker.invoke(operatorHandle, ExpressionInterpreter.this.session.getSqlFunctionProperties(), argumentValues);
        }

        private Expression toExpression(Object base, Type type) {
            return ExpressionInterpreter.this.literalEncoder.toExpression(base, type);
        }

        private boolean isSerializable(Object value, Type type) {
            Objects.requireNonNull(type, "type is null");
            return value instanceof Expression || LiteralEncoder.isSupportedLiteralType(type) && LiteralEncoder.estimatedSizeInBytes(value) <= 1000L;
        }

        private List<Expression> toExpressions(List<Object> values, List<Type> types) {
            return ExpressionInterpreter.this.literalEncoder.toExpressions(values, types);
        }
    }
}

